/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.enderio;

import crazypants.enderio.base.farming.registry.Commune;
import crazypants.enderio.base.farming.registry.Registry;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.HashedItemStack;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Commune.class}, remap=false)
public class MixinCommune {
    @Unique
    private final Map<HashedItemStack, Boolean> stellar_core$cache = new WeakHashMap<HashedItemStack, Boolean>();

    @Inject(method={"canPlant"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectCanPlant(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (!StellarCoreConfig.PERFORMANCE.enderIO.commune) {
            return;
        }
        HashedItemStack hashedStack = HashedItemStack.ofTagUnsafe(stack);
        Boolean cache = this.stellar_core$cache.get(hashedStack);
        if (cache != null) {
            cir.setReturnValue((Object)cache);
            return;
        }
        boolean result = Registry.foreach(joe -> joe.canPlant(stack) ? Boolean.TRUE : null) != null;
        this.stellar_core$cache.put(hashedStack.copy(), result);
        cir.setReturnValue((Object)result);
    }
}

