/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.mod.Mods;
import github.kasuminova.stellarcore.common.util.StellarLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraftforge.fml.common.Loader;
import zone.rong.mixinbooter.ILateMixinLoader;

public class StellarCoreLateMixinLoader
implements ILateMixinLoader {
    private static final Map<String, BooleanSupplier> MIXIN_CONFIGS = new LinkedHashMap<String, BooleanSupplier>();

    public List<String> getMixinConfigs() {
        return new ArrayList<String>(MIXIN_CONFIGS.keySet());
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        BooleanSupplier supplier = MIXIN_CONFIGS.get(mixinConfig);
        if (supplier == null) {
            StellarLog.LOG.warn("[StellarCore-MixinLoader] Mixin config {} is not found in config map! It will never be loaded.", (Object)mixinConfig);
            return false;
        }
        boolean shouldLoad = supplier.getAsBoolean();
        if (!shouldLoad) {
            StellarLog.LOG.info("[StellarCore-MixinLoader] Mixin config {} is disabled by config or mod is not loaded.", (Object)mixinConfig);
        }
        return shouldLoad;
    }

    private static boolean modLoaded(String modID) {
        return Loader.isModLoaded((String)modID);
    }

    private static void addModdedMixinCFG(String mixinConfig, String modID) {
        MIXIN_CONFIGS.put(mixinConfig, () -> StellarCoreLateMixinLoader.modLoaded(modID));
    }

    private static void addModdedMixinCFG(String mixinConfig, String modID, BooleanSupplier condition) {
        MIXIN_CONFIGS.put(mixinConfig, () -> StellarCoreLateMixinLoader.modLoaded(modID) && condition.getAsBoolean());
    }

    private static void addModdedMixinCFG(String mixinConfig, String[] modIDs, BooleanSupplier condition) {
        MIXIN_CONFIGS.put(mixinConfig, () -> Arrays.stream(modIDs).allMatch(Loader::isModLoaded) && condition.getAsBoolean());
    }

    private static void addModdedMixinCFG(String mixinConfig, String modID, String ... modIDs) {
        MIXIN_CONFIGS.put(mixinConfig, () -> StellarCoreLateMixinLoader.modLoaded(modID) && Arrays.stream(modIDs).allMatch(Loader::isModLoaded));
    }

    private static void addMixinCFG(String mixinConfig) {
        MIXIN_CONFIGS.put(mixinConfig, () -> true);
    }

    private static void addMixinCFG(String mixinConfig, BooleanSupplier conditions) {
        MIXIN_CONFIGS.put(mixinConfig, conditions);
    }

    static {
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_advancedrocketry.json", "advancedrocketry");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_ae.json", "appliedenergistics2");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_ancientspellcraft.json", "ancientspellcraft");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_armourers_workshop.json", "armourers_workshop");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_astralsorcery.json", "astralsorcery");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_avaritia.json", "avaritia");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_avaritiaddons.json", "avaritiaddons");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_betterchat.json", "betterchat");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_biomesoplenty.json", "biomesoplenty");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_bloodmagic.json", "bloodmagic");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_botania.json", "botania");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_cfm.json", "cfm", () -> StellarCoreConfig.BUG_FIXES.mrCrayfishFurniture.imageCache);
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_chisel.json", "chisel");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_cofhcore.json", "cofhcore");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_ctm.json", "ctm", () -> StellarCoreConfig.PERFORMANCE.ctm.textureMetadataHandler);
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_cucumber.json", "cucumber");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_customloadingscreen.json", "customloadingscreen");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_customstartinggear.json", "customstartinggear");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_deepmoblearing.json", "deepmoblearning");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_draconicevolution.json", "draconicevolution");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_ebwizardry.json", "ebwizardry");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_endercore.json", "endercore");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_enderio.json", "enderio");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_enderioconduits.json", "enderio", "enderioconduits");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_enderioconduits_energy.json", "enderio", "enderioconduits");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_enderutilities.json", "enderutilities");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_extrabotany.json", "extrabotany");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_fluxnetworks.json", "fluxnetworks");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_ftblib.json", "ftblib");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_ftbquests.json", "ftbquests");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_guguutils.json", "gugu-utils");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_ic2.json", "ic2");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_ic2_energynet.json", "ic2");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_igi.json", "ingameinfoxml");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_immersiveengineering.json", "immersiveengineering");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_jei.json", "jei", () -> StellarCoreConfig.PERFORMANCE.vanilla.stitcherCache);
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_threng.json", "threng");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_legendarytooltips.json", "legendarytooltips");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_libnine.json", "libnine", () -> StellarCoreConfig.PERFORMANCE.vanilla.parallelModelLoader);
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_mek_top.json", new String[]{"mekanism", "theoneprobe"}, () -> StellarCoreConfig.FEATURES.mekanism.topSupport);
        StellarCoreLateMixinLoader.addMixinCFG("mixins.stellar_core_mekanism.json", () -> Mods.MEK.loaded() && !Mods.MEKCEU.loaded());
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_mets.json", "mets");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_modularrouters.json", "modularrouters");
        StellarCoreLateMixinLoader.addMixinCFG("mixins.stellar_core_nco.json", Mods.NCO::loaded);
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_psi.json", "psi");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_rgb_chat.json", "jianghun");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_scalingguis.json", "scalingguis");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_specialmobs.json", "specialmobs");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_sync.json", "sync");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_sync_techguns.json", "sync", "techguns");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_tconevo.json", "tconevo");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_tconstruct.json", "tconstruct");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_techguns.json", "techguns");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_theoneprobe.json", "theoneprobe");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_thermaldynamics.json", "thermaldynamics");
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_thermalexpansion.json", "thermalexpansion", () -> StellarCoreConfig.BUG_FIXES.thermalExpansion.containerSatchelFilter);
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_touhou_little_maid.json", "touhou_little_maid", () -> StellarCoreConfig.PERFORMANCE.tlm.modelDataCanonicalization);
        StellarCoreLateMixinLoader.addModdedMixinCFG("mixins.stellar_core_vintagefix.json", "vintagefix");
    }
}

