/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.integration.censoredasm.CensoredASMCompat;
import github.kasuminova.stellarcore.common.mod.Mods;
import github.kasuminova.stellarcore.common.util.StellarEnvironment;
import github.kasuminova.stellarcore.common.util.StellarLog;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.spongepowered.asm.mixin.Mixins;

public class StellarCoreEarlyMixinLoader
implements IFMLLoadingPlugin {
    private static final Map<String, BooleanSupplier> MIXIN_CONFIGS = new LinkedHashMap<String, BooleanSupplier>();

    private static void addMixinCFG(String mixinConfig) {
        MIXIN_CONFIGS.put(mixinConfig, () -> true);
    }

    private static void addMixinCFG(String mixinConfig, BooleanSupplier conditions) {
        MIXIN_CONFIGS.put(mixinConfig, conditions);
    }

    public static boolean isCleanroomLoader() {
        try {
            Class.forName("com.cleanroommc.boot.Main");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return null;
    }

    @Nullable
    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        MIXIN_CONFIGS.forEach((config, supplier) -> {
            if (supplier == null) {
                StellarLog.LOG.warn("[StellarCore-MixinLoader] Mixin config {} is not found in config map! It will never be loaded.", config);
                return;
            }
            boolean shouldLoad = supplier.getAsBoolean();
            if (!shouldLoad) {
                StellarLog.LOG.info("[StellarCore-MixinLoader] Mixin config {} is disabled by config or mod is not loaded.", config);
                return;
            }
            StellarLog.LOG.info("[StellarCore-MixinLoader] Adding {} to mixin configuration.", config);
            Mixins.addConfiguration((String)config);
        });
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static {
        StellarEnvironment.init();
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_advancements.json", () -> StellarCoreConfig.FEATURES.vanilla.asyncAdvancementSerialize);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_bakedmodel.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.simpleBakedModelCanonicalization);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_bakedquad.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.bakedQuadVertexDataCanonicalization);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_blockfaceuv.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.blockFaceUVsCanonicalization);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_blockpart.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.blockPartDataStructure);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_blockstateimpl.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.blockStateImplementationHashCodeCache);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_chunktecache.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.chunkTECache);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_chunktemap.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.chunkTEMap);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_chunktequeue.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.chunkTEQueue);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_classmultimap.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.classMultiMap);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_entitytracker.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.entitytracker);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_itemstack_cap.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.asyncItemStackCapabilityInit && (!CensoredASMCompat.isPresent() || !CensoredASMCompat.checkDelayItemStackCapInitEnabled()));
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_longnbtkiller.json", () -> StellarCoreConfig.BUG_FIXES.vanilla.longNBTKiller);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_modelblock.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.modelBlockStringCanonicalization && CensoredASMCompat.isPresent());
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_nbtmaplist.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.nbtTag && (!CensoredASMCompat.isPresent() || !CensoredASMCompat.checkNBTMapModified()));
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_nbtpool.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.nbtPrimitiveConstantsPool);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_nethandlerplayserver.json", () -> StellarCoreConfig.BUG_FIXES.container.containerInteract);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_nnlist.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.nonNullList);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_noglerror.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.noGlError);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_property.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.propertyEnumHashCodeCache);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_randomtick.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.parallelRandomBlockTicker);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_renderglobal.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.alwaysDeferChunkUpdates);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_resourcelocation.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.resourceLocationCanonicalization && !StellarCoreConfig.PERFORMANCE.vanilla.resourceLocationCanonicalizationAsync);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_resourcelocation_async.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.resourceLocationCanonicalization && StellarCoreConfig.PERFORMANCE.vanilla.resourceLocationCanonicalizationAsync);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_resourcepack.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.resourceExistStateCache);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_world.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.capturedBlockSnapshots);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_world_load.json", () -> StellarCoreConfig.FEATURES.vanilla.handleClientWorldLoad);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_world_pos_judgement.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.worldBlockPosJudgement);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_worldclient.json", () -> StellarCoreConfig.BUG_FIXES.vanilla.clientNullBlockPacket);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_worldserver.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.worldServerGetPendingBlockUpdates);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_statemapperbase.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.parallelModelLoader || StellarCoreConfig.PERFORMANCE.vanilla.stateMapperBase);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_stitcher.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.stitcherCache);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_minecraft_texture_load.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.parallelTextureLoad);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_forge.json", () -> StellarCoreConfig.PERFORMANCE.customLoadingScreen.splashProgress);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_forge_asmdatatable.json", () -> StellarCoreConfig.PERFORMANCE.forge.asmDataTable);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_forge_asmmodparser.json", () -> StellarCoreConfig.PERFORMANCE.forge.asmModParser);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_forge_bakedquad.json", () -> StellarCoreConfig.PERFORMANCE.forge.unpackedBakedQuadDataCanonicalization);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_forge_bakedquad_vertexdata.json", () -> StellarCoreConfig.PERFORMANCE.forge.unpackedBakedQuadVertexDataCanonicalization);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_forge_capability.json", () -> StellarCoreConfig.PERFORMANCE.forge.deallocateEmptyCapabilityNBT);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_forge_chunkmanager.json", () -> StellarCoreConfig.PERFORMANCE.forge.chunkManager);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_forge_modelloader.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.parallelModelLoader);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_forge_registry.json", () -> StellarCoreConfig.FEATURES.vanilla.forgeRegistryRemoveList.length > 0);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_hudcaching.json", () -> StellarCoreConfig.PERFORMANCE.vanilla.hudCaching);
        StellarCoreEarlyMixinLoader.addMixinCFG("mixins.stellar_core_ebwizardry_early.json", () -> StellarCoreConfig.PERFORMANCE.ebWizardry.dispenserCastingData && !Mods.TICK_CENTRAL.loaded());
    }
}

