/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.util;

import github.kasuminova.stellarcore.common.util.FakeArrayList;
import github.kasuminova.stellarcore.common.util.TagListIterator;
import github.kasuminova.stellarcore.common.util.TagListListIterator;
import github.kasuminova.stellarcore.mixin.util.StellarNBTTagList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;

public class NBTTagBackingList
extends FakeArrayList<NBTBase> {
    private StellarNBTTagList changeHandler = null;

    public NBTTagBackingList(int initialCapacity) {
        super(new ObjectArrayList(), initialCapacity);
    }

    public NBTTagBackingList() {
        super(new ObjectArrayList());
    }

    public NBTTagBackingList(Collection<? extends NBTBase> c) {
        super(new ObjectArrayList(c));
    }

    public void setChangeHandler(StellarNBTTagList changeHandler) {
        this.changeHandler = changeHandler;
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        if (this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        return super.toArray();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(T[] a) {
        if (this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        return super.toArray(a);
    }

    @Override
    public NBTBase set(int index, NBTBase element) {
        if (this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        return super.set(index, element);
    }

    @Override
    public boolean add(NBTBase e) {
        if (this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        return super.add(e);
    }

    @Override
    public void add(int index, NBTBase element) {
        if (this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        super.add(index, element);
    }

    @Override
    public NBTBase remove(int index) {
        NBTBase removed = (NBTBase)super.remove(index);
        if (removed != null && this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        return removed;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = super.remove(o);
        if (removed && this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        return removed;
    }

    @Override
    public void clear() {
        if (this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends NBTBase> c) {
        if (!c.isEmpty() && this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends NBTBase> c) {
        if (!c.isEmpty() && this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        return super.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = super.removeAll(c);
        if (removed && this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retained = super.retainAll(c);
        if (retained && this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        return retained;
    }

    @Override
    @Nonnull
    public ListIterator<NBTBase> listIterator(int index) {
        return new TagListListIterator(super.listIterator(index), this.changeHandler);
    }

    @Override
    @Nonnull
    public ListIterator<NBTBase> listIterator() {
        return new TagListListIterator(super.listIterator(), this.changeHandler);
    }

    @Override
    @Nonnull
    public Iterator<NBTBase> iterator() {
        return new TagListIterator(super.iterator(), this.changeHandler);
    }

    public Iterator<NBTBase> unwrappedIterator() {
        return super.iterator();
    }

    public ListIterator<NBTBase> unwrappedListIterator(int index) {
        return super.listIterator(index);
    }

    public ListIterator<NBTBase> unwrappedListIterator() {
        return super.listIterator();
    }

    @Override
    @Nonnull
    public List<NBTBase> subList(int fromIndex, int toIndex) {
        if (this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        return super.subList(fromIndex, toIndex);
    }

    @Override
    public boolean removeIf(Predicate<? super NBTBase> filter) {
        boolean removed = super.removeIf(filter);
        if (removed && this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        return removed;
    }

    @Override
    public void replaceAll(UnaryOperator<NBTBase> operator) {
        if (this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        super.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super NBTBase> c) {
        if (this.changeHandler != null) {
            this.changeHandler.stellar_core$onModified();
        }
        super.sort(c);
    }

    @Override
    public Object clone() {
        NBTTagBackingList cloned = new NBTTagBackingList(this.internal);
        cloned.changeHandler = null;
        return cloned;
    }
}

