/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.pool;

import github.kasuminova.stellarcore.common.pool.AsyncCanonicalizePoolBase;
import github.kasuminova.stellarcore.common.util.StellarLog;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.Nullable;

public abstract class AsyncCanonicalizePool<T>
extends AsyncCanonicalizePoolBase<T> {
    public static final long CLEAR_TIMEOUT_MS = 10000L;
    private final AtomicInteger locked = new AtomicInteger(0);
    protected volatile long processedCount = 0L;
    private volatile Future<Void> clearTask = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T canonicalize(@Nullable T target) {
        Set<T> pool;
        if (target == null) {
            return null;
        }
        T processed = this.preProcess(target);
        this.locked.incrementAndGet();
        Set<T> set = pool = this.getPoolKeySet();
        synchronized (set) {
            T canonicalized = null;
            try {
                canonicalized = this.canonicalizeInternal(processed);
            }
            catch (Throwable e) {
                StellarLog.LOG.error("Pool {} caught a error while canonicalizing `{}`.", (Object)this.getName(), target);
                StellarLog.LOG.error((Object)e);
            }
            this.locked.decrementAndGet();
            ++this.processedCount;
            return canonicalized;
        }
    }

    protected T preProcess(T target) {
        return target;
    }

    protected abstract T canonicalizeInternal(T var1);

    @Override
    public synchronized void clear() {
        if (this.clearTask != null) {
            if (!this.clearTask.isDone()) {
                return;
            }
            this.clearTask = null;
        }
        this.clearTask = CompletableFuture.runAsync(() -> {
            Set<T> pool;
            long start = System.currentTimeMillis();
            while (this.locked.get() > 0) {
                if (System.currentTimeMillis() - start > 10000L) {
                    StellarLog.LOG.warn("Pool {} Wait for task completion timeout (over {}ms), force clearing.", (Object)this.getName(), (Object)10000L);
                    break;
                }
                LockSupport.parkNanos(1000000L);
            }
            this.onClearPre();
            this.processedCount = 0L;
            Set<T> set = pool = this.getPoolKeySet();
            synchronized (set) {
                this.locked.set(0);
                this.clearPool();
            }
            this.onClearPost();
            this.clearTask = null;
        });
    }

    protected abstract void clearPool();

    public void onClearPre() {
    }

    public void onClearPost() {
    }

    @Override
    public long getProcessedCount() {
        return this.processedCount;
    }

    @Override
    public int getUniqueCount() {
        return this.getPoolKeySet().size();
    }

    protected abstract Set<T> getPoolKeySet();
}

