/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.config.element;

import github.kasuminova.stellarcore.common.config.element.ConfigElementPrimitive;
import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraftforge.common.config.Config;

public final class ElementInteger
implements ConfigElementPrimitive<Integer> {
    private final Object object;
    private final Field field;

    public ElementInteger(Object object, Field field) {
        this.object = object;
        this.field = field;
    }

    @Override
    public Integer get() throws IllegalAccessException {
        return this.field.getInt(this.object);
    }

    @Override
    public void set(Integer newValue) throws IllegalAccessException {
        this.field.setInt(this.object, newValue);
    }

    public int getMin() {
        if (this.field.isAnnotationPresent(Config.RangeInt.class)) {
            return this.field.getAnnotation(Config.RangeInt.class).min();
        }
        return Integer.MIN_VALUE;
    }

    public int getMax() {
        if (this.field.isAnnotationPresent(Config.RangeInt.class)) {
            return this.field.getAnnotation(Config.RangeInt.class).max();
        }
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return "ElementInteger[" + "object=" + this.object + "," + "field=" + this.field + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.object != null ? this.object.hashCode() : 0);
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals(((ElementInteger)arg0).object, this.object)) {
            return false;
        }
        return Objects.equals(((ElementInteger)arg0).field, this.field);
        {
        }
    }

    @Override
    public Object object() {
        return this.object;
    }

    @Override
    public Field field() {
        return this.field;
    }
}

