/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.client.util;

import github.kasuminova.stellarcore.client.hitokoto.HitokotoAPI;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.StellarLog;
import github.kasuminova.stellarcore.mixin.StellarCoreEarlyMixinLoader;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.lwjgl.opengl.Display;

public class TitleUtils {
    public static final String VANILLA_TITLE = "Minecraft 1.12.2";
    public static String currentTitle = null;
    public static String lastCurrentTitle = null;
    public static boolean unsupportedPlatform = false;

    public static void setRandomTitle(String state) {
        if (!StellarCoreConfig.FEATURES.enableTitle) {
            return;
        }
        lastCurrentTitle = currentTitle;
        String hitokotoCache = HitokotoAPI.getHitokotoCache();
        if (hitokotoCache != null) {
            currentTitle = TitleUtils.buildTitle(state, hitokotoCache);
            TitleUtils.setTitle();
        } else {
            CompletableFuture.runAsync(HitokotoAPI::getRandomHitokoto);
            currentTitle = TitleUtils.buildTitle(state, null);
            TitleUtils.setTitle();
        }
    }

    public static void setRandomTitle() {
        if (!StellarCoreConfig.FEATURES.enableTitle) {
            return;
        }
        lastCurrentTitle = currentTitle;
        String hitokotoCache = HitokotoAPI.getHitokotoCache();
        if (hitokotoCache != null) {
            currentTitle = TitleUtils.buildTitle(null, hitokotoCache);
            TitleUtils.setTitle();
        } else {
            currentTitle = TitleUtils.buildTitle(null, null);
            TitleUtils.setTitle();
        }
    }

    public static void setRandomTitleSync(String state) {
        if (!StellarCoreConfig.FEATURES.enableTitle) {
            return;
        }
        lastCurrentTitle = currentTitle;
        currentTitle = TitleUtils.buildTitle(state, HitokotoAPI.getHitokotoCache());
    }

    public static void setRandomTitleSync() {
        if (!StellarCoreConfig.FEATURES.enableTitle) {
            return;
        }
        lastCurrentTitle = currentTitle;
        currentTitle = TitleUtils.buildTitle(null, HitokotoAPI.getHitokotoCache());
    }

    public static String buildTitle(String state, String hitokoto) {
        String title = StellarCoreConfig.FEATURES.title;
        boolean useHitokoto = StellarCoreConfig.FEATURES.hitokoto;
        if (state == null) {
            if (!useHitokoto || hitokoto == null) {
                return title;
            }
            return String.format("%s | %s", title, hitokoto);
        }
        if (!useHitokoto || hitokoto == null) {
            return String.format("%s | %s", title, state);
        }
        return String.format("%s | %s | %s", title, state, hitokoto);
    }

    public static void checkTitleState() {
        if (!StellarCoreConfig.FEATURES.enableTitle) {
            return;
        }
        if (currentTitle == null) {
            return;
        }
        String title = Display.getTitle();
        if (!title.equals(currentTitle)) {
            TitleUtils.setTitle();
        }
    }

    private static void setTitle() {
        if (StellarCoreEarlyMixinLoader.isCleanroomLoader() && !unsupportedPlatform) {
            try {
                Class<?> Display2 = Class.forName("org.lwjgl.opengl.Display");
                Method getWindow = Display2.getDeclaredMethod("getWindow", new Class[0]);
                long result = (Long)getWindow.invoke(null, new Object[0]);
                if (result != 0L) {
                    Class<?> GLFW = Class.forName("org.lwjgl3.glfw.GLFW");
                    Method glfwSetWindowTitle = GLFW.getDeclaredMethod("glfwSetWindowTitle", Long.TYPE, CharSequence.class);
                    glfwSetWindowTitle.invoke(null, result, currentTitle);
                }
            }
            catch (Exception e) {
                StellarLog.LOG.warn("Failed to set CleanroomLoader title, maybe platform is unsupported.", (Throwable)e);
                unsupportedPlatform = true;
            }
            return;
        }
        Display.setTitle((String)currentTitle);
    }
}

