/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.client.gui.font;

import com.fred.jianghun.truergb.IColor;
import com.fred.jianghun.truergb.RGBSettings;
import github.kasuminova.stellarcore.client.gui.font.RGBSettingsUtils;
import github.kasuminova.stellarcore.client.gui.font.TextRenderFunction;
import github.kasuminova.stellarcore.client.gui.font.TextRenderInfo;
import github.kasuminova.stellarcore.client.gui.font.TextWrapInfo;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;

public class CachedRGBFontRenderer
extends FontRenderer {
    private static final Map<TextRenderInfo, List<TextRenderFunction>> TEXT_RENDER_CACHE = new WeakHashMap<TextRenderInfo, List<TextRenderFunction>>();
    private static final Map<TextWrapInfo, List<String>> LISTED_CACHE = new WeakHashMap<TextWrapInfo, List<String>>();

    CachedRGBFontRenderer(GameSettings gameSettingsIn, ResourceLocation location, TextureManager textureManagerIn, boolean unicode) {
        super(gameSettingsIn, location, textureManagerIn, unicode);
    }

    public static void overrideFontRenderer() {
        Minecraft mc = Minecraft.func_71410_x();
        CachedRGBFontRenderer renderer = new CachedRGBFontRenderer(mc.field_71474_y, new ResourceLocation("textures/font/ascii.png"), mc.field_71446_o, false);
        mc.field_71466_p = renderer;
        if (mc.field_71474_y.field_74363_ab != null) {
            renderer.func_78264_a(mc.func_152349_b());
            renderer.func_78275_b(mc.func_135016_M().func_135044_b());
        }
    }

    public static List<String> mapListedString(List<String> listed, LinkedList<String> strList, LinkedList<String> colors) {
        ArrayList<String> mapped = new ArrayList<String>();
        StringBuilder mapping = new StringBuilder();
        int lastMappedLineIndex = 0;
        int lastMappedLineStrIndex = 0;
        for (int i = 0; i < listed.size(); ++i) {
            String s = listed.get(i);
            int lastMappedStrIndex = 0;
            StringBuilder sb = new StringBuilder();
            char[] charArray = s.toCharArray();
            int strLen = charArray.length;
            for (int j = 0; j < strLen; ++j) {
                char ch = charArray[j];
                mapping.append(ch);
                String strFirst = strList.peekFirst();
                if (strFirst == null || colors.getFirst() == null) {
                    sb.append(ch);
                    continue;
                }
                if (strFirst.contentEquals(mapping) || j + 1 >= strLen && strFirst.equals(mapping.toString() + ' ')) {
                    String color = colors.pollFirst();
                    sb.insert(lastMappedStrIndex, color);
                    sb.append(ch);
                    if (lastMappedLineIndex + 1 == i) {
                        StringBuilder lastMappedStrSb = new StringBuilder((String)mapped.get(lastMappedLineIndex));
                        lastMappedStrSb.insert(lastMappedLineStrIndex, color);
                        mapped.set(lastMappedLineIndex, lastMappedStrSb.toString());
                    }
                    lastMappedLineIndex = i;
                    lastMappedStrIndex = sb.length();
                    strList.pollFirst();
                    mapping.setLength(0);
                    continue;
                }
                sb.append(ch);
            }
            lastMappedLineStrIndex = lastMappedStrIndex;
            mapped.add(sb.toString());
        }
        return mapped;
    }

    public int func_175065_a(@Nullable String text, float x, float y, int color, boolean dropShadow) {
        if (text == null) {
            return 0;
        }
        TextRenderInfo textRenderInfo = new TextRenderInfo(text, color);
        List<TextRenderFunction> cachedRenderFunction = TEXT_RENDER_CACHE.get(textRenderInfo);
        if (cachedRenderFunction != null) {
            return this.fastDrawString(x, y, dropShadow, cachedRenderFunction);
        }
        cachedRenderFunction = new LinkedList<TextRenderFunction>();
        List settings = RGBSettings.split((String)text);
        int currentColorHex = color;
        this.field_78295_j = x;
        for (Tuple setting : settings) {
            String s = (String)setting.func_76341_a();
            RGBSettings set = (RGBSettings)setting.func_76340_b();
            if (set.isFixedColor()) {
                currentColorHex = Optional.ofNullable(set.getColorAt(0)).map(IColor::toInt).orElse(color);
                Color currentColor = new Color(currentColorHex);
                int finalCurrentColor = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), color >> 24 & 0xFF).getRGB();
                String toRender = set.getFormatString() + s;
                cachedRenderFunction.add((_y, _dropShadow) -> super.func_175065_a(toRender, this.field_78295_j, _y, finalCurrentColor, _dropShadow));
                continue;
            }
            for (int i = 0; i < s.length(); ++i) {
                currentColorHex = Optional.ofNullable(set.getColorAt(i)).map(IColor::toInt).orElse(color);
                Color currentColor = new Color(currentColorHex);
                int finalCurrentColor = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), color >> 24 & 0xFF).getRGB();
                String toRender = set.getFormatString() + s.charAt(i);
                cachedRenderFunction.add((_y, _dropShadow) -> super.func_175065_a(toRender, this.field_78295_j, _y, finalCurrentColor, _dropShadow));
            }
        }
        TEXT_RENDER_CACHE.put(textRenderInfo, cachedRenderFunction);
        return this.fastDrawString(x, y, dropShadow, cachedRenderFunction);
    }

    public int fastDrawString(float x, float y, boolean dropShadow, List<TextRenderFunction> renderFunctions) {
        this.field_78295_j = x;
        for (TextRenderFunction renderFunction : renderFunctions) {
            renderFunction.renderText(y, dropShadow);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        return (int)this.field_78295_j;
    }

    public int func_78256_a(@Nullable String text) {
        if (text == null) {
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        for (Tuple stringRGBSettingsTuple : RGBSettings.split((String)text)) {
            String first = (String)stringRGBSettingsTuple.func_76341_a();
            sb.append(first);
        }
        return super.func_78256_a(sb.toString());
    }

    @Nonnull
    public List<String> func_78271_c(@Nonnull String content, int wrapWidth) {
        TextWrapInfo wrapInfo = new TextWrapInfo(content, wrapWidth);
        List<String> cachedListed = LISTED_CACHE.get(wrapInfo);
        if (cachedListed != null) {
            return cachedListed;
        }
        StringBuilder sb = new StringBuilder();
        LinkedList<String> strList = new LinkedList<String>();
        LinkedList<String> rgbSettingList = new LinkedList<String>();
        for (Tuple<String, String> strSettings : RGBSettingsUtils.splitRGBAndContents(content)) {
            rgbSettingList.add((String)strSettings.func_76341_a());
            String str = (String)strSettings.func_76340_b();
            sb.append(str);
            strList.add(str.replace("\n", ""));
        }
        cachedListed = CachedRGBFontRenderer.mapListedString(super.func_78271_c(sb.toString(), wrapWidth), strList, rgbSettingList);
        LISTED_CACHE.put(wrapInfo, cachedListed);
        return cachedListed;
    }
}

