/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.integration;

import com.direwolf20.buildinggadgets.common.integration.IntegrationHandler;
import com.direwolf20.buildinggadgets.common.tools.NetworkIO;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;

public abstract class NetworkProvider
implements IntegrationHandler.IIntegratedMod {
    private boolean isLoaded = true;
    private static final Set<NetworkProvider> PROVIDERS = new HashSet<NetworkProvider>();

    @Override
    public void initialize(IntegrationHandler.Phase phase) {
        if (phase == IntegrationHandler.Phase.PRE_INIT) {
            this.isLoaded = true;
            PROVIDERS.add(this);
        }
    }

    @Nullable
    protected abstract IItemHandler getWrappedNetworkInternal(TileEntity var1, EntityPlayer var2, NetworkIO.Operation var3);

    @Nullable
    private IItemHandler getWrappedNetworkIfLoaded(TileEntity te, EntityPlayer player, NetworkIO.Operation operation) {
        return !this.isLoaded ? null : this.getWrappedNetworkInternal(te, player, operation);
    }

    @Nullable
    public static IItemHandler getWrappedNetwork(TileEntity te, EntityPlayer player, NetworkIO.Operation operation) {
        NetworkProvider provider;
        IItemHandler network = null;
        Iterator<NetworkProvider> iterator = PROVIDERS.iterator();
        while (iterator.hasNext() && (network = (provider = iterator.next()).getWrappedNetworkIfLoaded(te, player, operation)) == null) {
        }
        return network;
    }
}

