/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.placement;

import com.direwolf20.buildinggadgets.common.building.IPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public final class Stair
implements IPlacementSequence {
    private final BlockPos base;
    private final BlockPos target;
    private final EnumFacing horizontalAdvance;
    private final EnumFacing verticalAdvance;
    private final Region region;
    private final int range;

    public static Stair create(BlockPos base, EnumFacing horizontalAdvance, EnumFacing verticalAdvance, int range) {
        return new Stair(base, horizontalAdvance, verticalAdvance, range);
    }

    @VisibleForTesting
    private Stair(BlockPos base, EnumFacing horizontalAdvance, EnumFacing verticalAdvance, int range) {
        this.base = base;
        this.target = base.func_177967_a(horizontalAdvance, range - 1).func_177967_a(verticalAdvance, range - 1);
        this.horizontalAdvance = horizontalAdvance;
        this.verticalAdvance = verticalAdvance;
        this.region = new Region((Vec3i)base, (Vec3i)this.target);
        this.range = range;
    }

    @VisibleForTesting
    private Stair(BlockPos base, BlockPos target, EnumFacing horizontalAdvance, EnumFacing verticalAdvance, Region region, int range) {
        this.base = base;
        this.target = target;
        this.horizontalAdvance = horizontalAdvance;
        this.verticalAdvance = verticalAdvance;
        this.region = region;
        this.range = range;
    }

    @Override
    public Region getBoundingBox() {
        return this.region;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.region.mayContain(x, y, z);
    }

    @Override
    public IPlacementSequence copy() {
        return new Stair(this.base, this.target, this.horizontalAdvance, this.verticalAdvance, this.region, this.range);
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        return new AbstractIterator<BlockPos>(){
            private BlockPos.MutableBlockPos current;
            private int i;
            {
                this.current = new BlockPos.MutableBlockPos(Stair.this.base);
                this.i = 0;
                this.current.func_189534_c(Stair.this.horizontalAdvance, -1).func_189534_c(Stair.this.verticalAdvance, -1);
            }

            protected BlockPos computeNext() {
                if (this.i >= Stair.this.range) {
                    return (BlockPos)this.endOfData();
                }
                ++this.i;
                this.current.func_189534_c(Stair.this.horizontalAdvance, 1).func_189534_c(Stair.this.verticalAdvance, 1);
                return this.current.func_185334_h();
            }
        };
    }
}

