/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.blocks.templatemanager;

import com.direwolf20.buildinggadgets.client.gui.AreaHelpText;
import com.direwolf20.buildinggadgets.client.gui.GuiButtonHelp;
import com.direwolf20.buildinggadgets.client.gui.GuiButtonHelpText;
import com.direwolf20.buildinggadgets.client.gui.IHoverHelpText;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.blocks.templatemanager.TemplateManagerCommands;
import com.direwolf20.buildinggadgets.common.blocks.templatemanager.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.common.blocks.templatemanager.TemplateManagerTileEntity;
import com.direwolf20.buildinggadgets.common.items.ModItems;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.PacketTemplateManagerLoad;
import com.direwolf20.buildinggadgets.common.network.PacketTemplateManagerPaste;
import com.direwolf20.buildinggadgets.common.network.PacketTemplateManagerSave;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.PasteToolBufferBuilder;
import com.direwolf20.buildinggadgets.common.tools.ToolDireBuffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.glu.Project;

public class TemplateManagerGUI
extends GuiContainer {
    public static final int HELP_TEXT_BACKGROUNG_COLOR = 1694460416;
    private boolean panelClicked;
    private int clickButton;
    private int clickX;
    private int clickY;
    private float initRotX;
    private float initRotY;
    private float initZoom;
    private float initPanX;
    private float initPanY;
    private float prevRotX;
    private float prevRotY;
    private float momentumX;
    private float momentumY;
    private float momentumDampening = 0.98f;
    private float rotX = 0.0f;
    private float rotY = 0.0f;
    private float zoom = 1.0f;
    private float panX = 0.0f;
    private float panY = 0.0f;
    private Rectangle panel = new Rectangle(8, 18, 62, 62);
    private GuiTextField nameField;
    private GuiButton buttonSave;
    private GuiButton buttonLoad;
    private GuiButton buttonCopy;
    private GuiButton buttonPaste;
    private GuiButtonHelp buttonHelp;
    private List<IHoverHelpText> helpTextProviders = new ArrayList<IHoverHelpText>();
    private TemplateManagerTileEntity te;
    private TemplateManagerContainer container;
    private static final ResourceLocation background = new ResourceLocation("buildinggadgets", "textures/gui/testcontainer.png");

    public TemplateManagerGUI(TemplateManagerTileEntity tileEntity, TemplateManagerContainer container) {
        super((Container)container);
        this.te = tileEntity;
        this.container = container;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.buttonHelp.isSelected()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            for (IHoverHelpText helpTextProvider : this.helpTextProviders) {
                helpTextProvider.drawRect((Gui)this, 1694460416);
            }
            GlStateManager.func_179145_e();
            for (IHoverHelpText helpTextProvider : this.helpTextProviders) {
                if (!helpTextProvider.isHovered(mouseX, mouseY)) continue;
                this.func_146279_a(helpTextProvider.getHoverHelpText(), mouseX, mouseY);
            }
        } else {
            this.func_191948_b(mouseX, mouseY);
        }
        if (this.buttonHelp.func_146115_a()) {
            this.func_146279_a(this.buttonHelp.getHoverText(), mouseX, mouseY);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.helpTextProviders.clear();
        this.buttonHelp = new GuiButtonHelp(100, this.field_147003_i + this.field_146999_f - 16, this.field_147009_r + 4);
        this.field_146292_n.add(this.buttonHelp);
        this.buttonSave = this.createAndAddButton(0, 79, 17, 30, 20, "Save");
        this.field_146292_n.add(this.buttonSave);
        this.buttonLoad = this.createAndAddButton(1, 137, 17, 30, 20, "Load");
        this.field_146292_n.add(this.buttonLoad);
        this.buttonCopy = this.createAndAddButton(2, 79, 61, 30, 20, "Copy");
        this.field_146292_n.add(this.buttonCopy);
        this.buttonPaste = this.createAndAddButton(3, 135, 61, 34, 20, "Paste");
        this.field_146292_n.add(this.buttonPaste);
        this.nameField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 8, this.field_147009_r + 6, 149, this.field_146289_q.field_78288_b);
        this.nameField.func_146203_f(50);
        this.nameField.func_146189_e(true);
        this.helpTextProviders.add(new AreaHelpText(this.nameField, "field.template_name"));
        this.helpTextProviders.add(new AreaHelpText(this.field_147002_h.func_75139_a(0), this.field_147003_i, this.field_147009_r, "slot.gadget"));
        this.helpTextProviders.add(new AreaHelpText(this.field_147002_h.func_75139_a(1), this.field_147003_i, this.field_147009_r, "slot.template"));
        this.helpTextProviders.add(new AreaHelpText(this.field_147003_i + 112, this.field_147009_r + 41, 22, 15, "arrow.data_flow"));
        this.helpTextProviders.add(new AreaHelpText(this.panel, this.field_147003_i, this.field_147009_r + 10, "preview"));
    }

    private GuiButton createAndAddButton(int id, int x, int y, int witdth, int height, String text) {
        GuiButtonHelpText button = new GuiButtonHelpText(id, this.field_147003_i + x, this.field_147009_r + y, witdth, height, text, text.toLowerCase());
        this.helpTextProviders.add(button);
        return button;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (!this.buttonCopy.func_146115_a() && !this.buttonPaste.func_146115_a()) {
            this.drawTexturedModalRectReverseX(this.field_147003_i + 112, this.field_147009_r + 41, 176, 0, 22, 15, this.buttonLoad.func_146115_a());
        }
        this.nameField.func_146194_f();
        this.drawStructure();
    }

    public void drawTexturedModalRectReverseX(int x, int y, int textureX, int textureY, int width, int height, boolean reverse) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        if (reverse) {
            bufferbuilder.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
            bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
            bufferbuilder.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
            bufferbuilder.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        } else {
            bufferbuilder.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
            bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
            bufferbuilder.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
            bufferbuilder.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    private void drawStructure() {
        int scale = new ScaledResolution(this.field_146297_k).func_78325_e();
        TemplateManagerGUI.func_73734_a((int)(this.field_147003_i + this.panel.getX() - 1), (int)(this.field_147009_r + this.panel.getY() - 1), (int)(this.field_147003_i + this.panel.getX() + this.panel.getWidth() + 1), (int)(this.field_147009_r + this.panel.getY() + this.panel.getHeight() + 1), (int)-7697782);
        ItemStack itemstack = this.container.func_75139_a(0).func_75211_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!itemstack.func_190926_b()) {
            String UUID = ModItems.gadgetCopyPaste.getUUID(itemstack);
            ToolDireBuffer bufferBuilder = PasteToolBufferBuilder.getBufferFromMap(UUID);
            if (bufferBuilder != null) {
                BlockPos startPos = ModItems.gadgetCopyPaste.getStartPos(itemstack);
                BlockPos endPos = ModItems.gadgetCopyPaste.getEndPos(itemstack);
                if (startPos == null || endPos == null) {
                    return;
                }
                double lengthX = Math.abs(startPos.func_177958_n() - endPos.func_177958_n());
                double lengthY = Math.abs(startPos.func_177956_o() - endPos.func_177956_o());
                double lengthZ = Math.abs(startPos.func_177952_p() - endPos.func_177952_p());
                double maxW = 96.0;
                double maxH = 176.0;
                double overW = Math.max(lengthX * 16.0 - 96.0, lengthZ * 16.0 - 96.0);
                double overH = lengthY * 16.0 - 176.0;
                double sc = 1.0;
                double zoomScale = 1.0;
                if (overW > 0.0 && overW >= overH) {
                    sc = 96.0 / (overW + 96.0);
                    zoomScale = overW / 40.0;
                } else if (overH > 0.0 && overH >= overW) {
                    sc = 176.0 / (overH + 176.0);
                    zoomScale = overH / 40.0;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179128_n((int)5889);
                GlStateManager.func_179094_E();
                GlStateManager.func_179096_D();
                Project.gluPerspective((float)60.0f, (float)((float)this.panel.getWidth() / (float)this.panel.getHeight()), (float)0.01f, (float)4000.0f);
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179083_b((int)((this.field_147003_i + this.panel.getX()) * scale), (int)(this.field_146297_k.field_71440_d - (this.field_147009_r + this.panel.getY() + this.panel.getHeight()) * scale), (int)(this.panel.getWidth() * scale), (int)(this.panel.getHeight() * scale));
                GlStateManager.func_179086_m((int)256);
                sc = 293.0 * sc + (double)this.zoom / zoomScale;
                GlStateManager.func_179139_a((double)sc, (double)sc, (double)sc);
                int moveX = startPos.func_177958_n() - endPos.func_177958_n();
                if (startPos.func_177958_n() >= endPos.func_177958_n()) {
                    --moveX;
                }
                GlStateManager.func_179137_b((double)((double)moveX / 1.75), (double)((double)(-Math.abs(startPos.func_177956_o() - endPos.func_177956_o())) / 1.75), (double)0.0);
                GlStateManager.func_179109_b((float)this.panX, (float)this.panY, (float)0.0f);
                GlStateManager.func_179109_b((float)((startPos.func_177958_n() - endPos.func_177958_n()) / 2 * -1), (float)((startPos.func_177956_o() - endPos.func_177956_o()) / 2 * -1), (float)((startPos.func_177952_p() - endPos.func_177952_p()) / 2 * -1));
                GlStateManager.func_179114_b((float)this.rotX, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)this.rotY, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)((startPos.func_177958_n() - endPos.func_177958_n()) / 2), (float)((startPos.func_177956_o() - endPos.func_177956_o()) / 2), (float)((startPos.func_177952_p() - endPos.func_177952_p()) / 2));
                this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                if (startPos.func_177958_n() - endPos.func_177958_n() == 0) {
                    // empty if block
                }
                if (bufferBuilder.func_178989_h() > 0) {
                    VertexFormat vertexformat = bufferBuilder.func_178973_g();
                    int i = vertexformat.func_177338_f();
                    ByteBuffer bytebuffer = bufferBuilder.func_178966_f();
                    List list = vertexformat.func_177343_g();
                    for (int j = 0; j < list.size(); ++j) {
                        VertexFormatElement vertexformatelement = (VertexFormatElement)list.get(j);
                        bytebuffer.position(vertexformat.func_181720_d(j));
                        vertexformatelement.func_177375_c().preDraw(vertexformat, j, i, bytebuffer);
                    }
                    GlStateManager.func_187439_f((int)bufferBuilder.func_178979_i(), (int)0, (int)bufferBuilder.func_178989_h());
                    int j1 = list.size();
                    for (int i1 = 0; i1 < j1; ++i1) {
                        VertexFormatElement vertexformatelement1 = (VertexFormatElement)list.get(i1);
                        vertexformatelement1.func_177375_c().postDraw(vertexformat, i1, i, bytebuffer);
                    }
                }
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5889);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179083_b((int)0, (int)0, (int)this.field_146297_k.field_71443_c, (int)this.field_146297_k.field_71440_d);
            }
        } else {
            this.rotX = 0.0f;
            this.rotY = 0.0f;
            this.zoom = 1.0f;
            this.momentumX = 0.0f;
            this.momentumY = 0.0f;
            this.panX = 0.0f;
            this.panY = 0.0f;
        }
    }

    protected void func_146284_a(GuiButton b) {
        if (b.field_146127_k == this.buttonHelp.field_146127_k) {
            this.buttonHelp.toggleSelected();
        } else if (b.field_146127_k == 0) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTemplateManagerSave(this.te.func_174877_v(), this.nameField.func_146179_b()));
        } else if (b.field_146127_k == 1) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTemplateManagerLoad(this.te.func_174877_v()));
        } else if (b.field_146127_k == 2) {
            TemplateManagerCommands.copyTemplate(this.container);
        } else if (b.field_146127_k == 3) {
            String CBString = TemplateManagerGUI.func_146277_j();
            if (GadgetUtils.mightBeLink(CBString)) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.pastefailed.linkcopied", new Object[0]).func_150261_e()), false);
                return;
            }
            try {
                ByteArrayOutputStream pasteStream = GadgetUtils.getPasteStream(JsonToNBT.func_180713_a((String)CBString), this.nameField.func_146179_b());
                if (pasteStream != null) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTemplateManagerPaste(pasteStream, this.te.func_174877_v(), this.nameField.func_146179_b()));
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.pastesuccess", new Object[0]).func_150261_e()), false);
                } else {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.pastetoobig", new Object[0]).func_150261_e()), false);
                }
            }
            catch (Throwable t) {
                BuildingGadgets.logger.error((Object)t);
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.pastefailed", new Object[0]).func_150261_e()), false);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.nameField.func_146201_a(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.nameField.func_146192_a(mouseX, mouseY, mouseButton)) {
            this.nameField.func_146195_b(true);
        } else {
            this.nameField.func_146195_b(false);
            if (this.panel.contains(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
                this.clickButton = mouseButton;
                this.panelClicked = true;
                this.clickX = Mouse.getX();
                this.clickY = Mouse.getY();
            }
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.panelClicked = false;
        this.initRotX = this.rotX;
        this.initRotY = this.rotY;
        this.initPanX = this.panX;
        this.initPanY = this.panY;
        this.initZoom = this.zoom;
    }

    protected void func_146979_b(int j, int i) {
        boolean doMomentum = false;
        if (this.panelClicked) {
            if (this.clickButton == 0) {
                this.prevRotX = this.rotX;
                this.prevRotY = this.rotY;
                this.rotX = this.initRotX - (float)(Mouse.getY() - this.clickY);
                this.rotY = this.initRotY + (float)(Mouse.getX() - this.clickX);
                this.momentumX = this.rotX - this.prevRotX;
                this.momentumY = this.rotY - this.prevRotY;
                doMomentum = false;
            } else if (this.clickButton == 1) {
                this.panX = this.initPanX + (float)((Mouse.getX() - this.clickX) / 8);
                this.panY = this.initPanY + (float)((Mouse.getY() - this.clickY) / 8);
            }
        }
        if (doMomentum) {
            this.rotX += this.momentumX;
            this.rotY += this.momentumY;
            this.momentumX *= this.momentumDampening;
            this.momentumY *= this.momentumDampening;
        }
        if (!this.nameField.func_146206_l() && this.nameField.func_146179_b().isEmpty()) {
            this.field_146289_q.func_78276_b("template name", this.nameField.field_146209_f - this.field_147003_i + 4, this.nameField.field_146210_g - this.field_147009_r, -10197916);
        }
        if (this.buttonSave.func_146115_a() || this.buttonLoad.func_146115_a() || this.buttonPaste.func_146115_a()) {
            this.drawSlotOverlay(this.buttonLoad.func_146115_a() ? this.container.func_75139_a(0) : this.container.func_75139_a(1));
        }
    }

    private void drawSlotOverlay(Slot slot) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1000.0f);
        TemplateManagerGUI.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)-1660903937);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1000.0f);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.zoom = this.initZoom + (float)(Mouse.getEventDWheel() / 2);
        if (this.zoom < -200.0f) {
            this.zoom = -200.0f;
        }
        if (this.zoom > 1000.0f) {
            this.zoom = 1000.0f;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.panelClicked) {
            this.initRotX = this.rotX;
            this.initRotY = this.rotY;
            this.initZoom = this.zoom;
            this.initPanX = this.panX;
            this.initPanY = this.panY;
        }
    }
}

