/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui.materiallist;

import com.direwolf20.buildinggadgets.common.tools.Sorter;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public enum SortingModes {
    NAME(Sorter.ItemStacks::byName, Sorter.ItemStacks::byNameInplace, "name", false),
    NAME_REVERSED(Sorter.ItemStacks::byName, Sorter.ItemStacks::byNameInplace, "nameReversed", true),
    COUNT(Sorter.ItemStacks::byCount, Sorter.ItemStacks::byCountInplace, "count", false),
    COUNT_REVERSED(Sorter.ItemStacks::byCount, Sorter.ItemStacks::byCountInplace, "countReversed", true);

    private final BiFunction<List<ItemStack>, Boolean, List<ItemStack>> sorter;
    private final BiFunction<List<ItemStack>, Boolean, List<ItemStack>> inplaceSorter;
    private final String translationKey;
    private final boolean reverse;

    private SortingModes(BiFunction<List<ItemStack>, Boolean, List<ItemStack>> sorter, BiFunction<List<ItemStack>, Boolean, List<ItemStack>> inplaceSorter, String translationKey, boolean reverse) {
        this.sorter = sorter;
        this.inplaceSorter = inplaceSorter;
        this.translationKey = "gui.buildinggadgets.materialList.button.sortingMode." + translationKey;
        this.reverse = reverse;
    }

    public List<ItemStack> sort(List<ItemStack> unsorted) {
        return this.sorter.apply(unsorted, this.reverse);
    }

    public void sortInplace(List<ItemStack> unsorted) {
        this.inplaceSorter.apply(unsorted, this.reverse);
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.translationKey, (Object[])new Object[0]);
    }

    public SortingModes next() {
        int nextIndex = this.ordinal() + 1;
        return SortingModes.values()[nextIndex >= SortingModes.values().length ? 0 : nextIndex];
    }
}

