/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.utils.IllegalPositionException;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Wrapper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Recipe {
    public static final String KEY_INPUT = "input";
    public static final String KEY_CATALYST = "catalyst";
    public static final String KEY_OUTPUT = "output";
    static final ILabel[] EMPTY_ARRAY = new ILabel[0];
    ILabel[] input;
    ILabel[] catalyst;
    ILabel[] output;

    public Recipe(NBTTagCompound nbt) {
        this(Recipe.readNbtList(nbt.func_150295_c(KEY_INPUT, 10)), Recipe.readNbtList(nbt.func_150295_c(KEY_CATALYST, 10)), Recipe.readNbtList(nbt.func_150295_c(KEY_OUTPUT, 10)));
    }

    public Recipe(List<ILabel> input, List<ILabel> catalyst, List<ILabel> output) {
        this(input.toArray(EMPTY_ARRAY), catalyst.toArray(EMPTY_ARRAY), output.toArray(EMPTY_ARRAY));
    }

    public Recipe(ILabel[] input, ILabel[] catalyst, ILabel[] output) {
        BiFunction<ILabel[], Integer, ILabel[]> convert = (ls, i) -> {
            ILabel[] ret = new ILabel[i.intValue()];
            if (((ILabel[])ls).length > i) {
                throw new RuntimeException("Too many labels");
            }
            System.arraycopy(ls, 0, ret, 0, ((ILabel[])ls).length);
            for (int j = ((ILabel[])ls).length; j < i; ++j) {
                ret[j] = ILabel.EMPTY;
            }
            return ret;
        };
        this.input = convert.apply(input, 14);
        this.catalyst = convert.apply(catalyst, 7);
        this.output = convert.apply(output, 7);
        Stream.of(input, output).forEach(i -> Arrays.stream(i).filter(j -> j != ILabel.EMPTY).findAny().orElseThrow(() -> new IllegalArgumentException("Invalid recipe")));
    }

    private static List<ILabel> readNbtList(NBTTagList list) {
        return StreamSupport.stream(list.spliterator(), false).filter(n -> n instanceof NBTTagCompound).map(n -> ILabel.SERIALIZER.deserialize((NBTTagCompound)n)).collect(Collectors.toList());
    }

    public int hashCode() {
        Wrapper<Integer> hash = new Wrapper<Integer>(0);
        Consumer<ILabel[]> hasher = ls -> Arrays.stream(ls).filter(Objects::nonNull).forEach(i -> {
            hash.value = (Integer)hash.value ^ i.hashCode();
        });
        hasher.accept(this.input);
        hasher.accept(this.catalyst);
        hasher.accept(this.output);
        return (Integer)hash.value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Recipe)) {
            return false;
        }
        Recipe r = (Recipe)obj;
        BiPredicate<ILabel[], ILabel[]> p = (i, j) -> {
            if (((ILabel[])i).length != ((ILabel[])j).length) {
                return false;
            }
            for (int k = 0; k < ((ILabel[])i).length; ++k) {
                if (i[k].equals(j[k])) continue;
                return false;
            }
            return true;
        };
        return p.test(this.input, r.input) && p.test(this.catalyst, r.catalyst) && p.test(this.output, r.output);
    }

    public ILabel[] getLabel(IO type) {
        switch (type) {
            case INPUT: {
                return this.input;
            }
            case OUTPUT: {
                return this.output;
            }
            case CATALYST: {
                return this.catalyst;
            }
        }
        throw new IllegalPositionException();
    }

    public ILabel getRep() {
        for (int i = 0; i < 8; ++i) {
            if (this.output[i] == ILabel.EMPTY) continue;
            return this.output[i];
        }
        return ILabel.EMPTY;
    }

    public NBTTagCompound serialize() {
        NBTTagCompound ret = new NBTTagCompound();
        Function<ILabel[], NBTTagList> convert = ls -> {
            ArrayList<ILabel> labels = new ArrayList<ILabel>();
            boolean start = false;
            for (int i = ((ILabel[])ls).length - 1; i >= 0; --i) {
                if (!start && ls[i] == ILabel.EMPTY) continue;
                labels.add(ls[i]);
                start = true;
            }
            NBTTagList r = new NBTTagList();
            new Utilities.ReversedIterator(labels).stream().forEach(l -> r.func_74742_a((NBTBase)ILabel.SERIALIZER.serialize((ILabel)l)));
            return r;
        };
        ret.func_74782_a(KEY_INPUT, (NBTBase)convert.apply(this.input));
        ret.func_74782_a(KEY_CATALYST, (NBTBase)convert.apply(this.catalyst));
        ret.func_74782_a(KEY_OUTPUT, (NBTBase)convert.apply(this.output));
        return ret;
    }

    public Optional<ILabel> matches(ILabel label) {
        return Arrays.stream(this.output).filter(i -> ILabel.MERGER.merge(label, (ILabel)i).isPresent()).findAny();
    }

    public long multiplier(ILabel label) {
        return Arrays.stream(this.output).filter(i -> ILabel.MERGER.merge(label, (ILabel)i).isPresent()).findAny().map(i -> {
            long amountA = label.getAmount();
            if (!label.isPercent()) {
                amountA = Math.multiplyExact(amountA, 100L);
            }
            long amountB = i.getAmount();
            if (!i.isPercent()) {
                amountB = Math.multiplyExact(amountB, 100L);
            }
            return (amountB + Math.abs(amountA) - 1L) / amountB;
        }).orElse(0L);
    }

    public static enum IO {
        INPUT,
        OUTPUT,
        CATALYST;


        public int getSize() {
            return this == INPUT ? 16 : 8;
        }
    }
}

