/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.pathos.network;

import io.netty.buffer.ByteBuf;
import ladysnake.pathos.api.ISickness;
import ladysnake.pathos.api.SicknessEffect;
import ladysnake.pathos.capability.CapabilitySickness;
import ladysnake.pathos.sickness.Sickness;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SicknessMessage
implements IMessage {
    private SicknessEffect effect;

    public SicknessMessage() {
    }

    public SicknessMessage(SicknessEffect effect) {
        this.effect = effect;
    }

    public void fromBytes(ByteBuf buf) {
        ISickness sickness = (ISickness)Sickness.REGISTRY.getValue(buf.readInt());
        float severity = buf.readFloat();
        int ticksSinceBeginning = buf.readInt();
        int ticksSinceLastPerform = buf.readInt();
        this.effect = new SicknessEffect(sickness, severity, ticksSinceBeginning, ticksSinceLastPerform);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(Sickness.REGISTRY.getID(this.effect.getSickness().getRegistryName()));
        buf.writeFloat(this.effect.getSeverity());
        buf.writeInt(this.effect.getTicksSinceBeginning());
        buf.writeInt(this.effect.getTicksSinceLastPerform());
    }

    public static class SicknessMessageHandler
    implements IMessageHandler<SicknessMessage, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(SicknessMessage message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> CapabilitySickness.getHandler((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(handler -> handler.addSickness(message.effect, (e1, e2) -> e2)));
            return null;
        }
    }
}

