/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.pathos.api;

import java.util.Objects;
import ladysnake.pathos.api.ISickness;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.RegistryManager;

public class SicknessEffect {
    private ISickness sickness;
    private float severity;
    private int ticksSinceBeginning;
    private int ticksSinceLastPerform;

    public SicknessEffect(ISickness sickness, float severity) {
        this(sickness, severity, 0, 0);
    }

    public SicknessEffect(ISickness sickness, float severity, int ticksSinceBeginning, int ticksSinceLastPerform) {
        this.sickness = sickness;
        this.severity = severity;
        this.ticksSinceBeginning = ticksSinceBeginning;
        this.ticksSinceLastPerform = ticksSinceLastPerform;
    }

    public SicknessEffect(NBTTagCompound nbt) {
        this.sickness = (ISickness)RegistryManager.ACTIVE.getRegistry(ISickness.class).getValue(new ResourceLocation(nbt.func_74779_i("effect")));
        this.severity = nbt.func_74760_g("severity");
        this.ticksSinceLastPerform = nbt.func_74762_e("ticksSinceLastPerform");
        this.ticksSinceBeginning = nbt.func_74762_e("ticksSinceBeginning");
    }

    public ISickness getSickness() {
        return this.sickness;
    }

    public void setSeverity(float severity) {
        this.severity = severity;
    }

    public float getSeverity() {
        return this.severity;
    }

    public SicknessEffect mergeSeverities(SicknessEffect other) {
        if (other.getSickness() == this.getSickness()) {
            this.setSeverity(this.getSeverity() + other.getSeverity());
            other.setSeverity(0.0f);
        }
        return this;
    }

    public void performEffect(EntityLivingBase carrier) {
        if (this.sickness.performEffect(carrier, this)) {
            this.ticksSinceLastPerform = 0;
        }
        ++this.ticksSinceLastPerform;
        ++this.ticksSinceBeginning;
    }

    public int getTicksSinceBeginning() {
        return this.ticksSinceBeginning;
    }

    public int getTicksSinceLastPerform() {
        return this.ticksSinceLastPerform;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("effect", Objects.requireNonNull(this.sickness.getRegistryName()).toString());
        nbt.func_74776_a("severity", this.severity);
        nbt.func_74768_a("ticksSinceLastPerform", this.ticksSinceLastPerform);
        nbt.func_74768_a("ticksSinceBeginning", this.ticksSinceBeginning);
        return nbt;
    }

    public void onCured(EntityLivingBase carrier) {
        this.sickness.onCured(this, carrier);
    }

    public String toString() {
        return "SicknessEffect{sickness=" + this.sickness + ", severity=" + this.severity + ", ticksSinceBeginning=" + this.ticksSinceBeginning + ", ticksSinceLastPerform=" + this.ticksSinceLastPerform + '}';
    }
}

