/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import ladysnake.gaspunk.GasPunk;
import ladysnake.gaspunk.api.customization.GrenadeSkins;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import org.apache.commons.lang3.tuple.Pair;

public class SpecialRewardChecker {
    private static Map<NetHandlerPlayServer, GrenadeSkins> playerSelectedSkins = Collections.synchronizedMap(new WeakHashMap());
    private static ImmutableMap<UUID, ImmutableList<GrenadeSkins>> specialPersons = ImmutableMap.of();
    private static final ImmutableList<GrenadeSkins> DEFAULT_SKINS = ImmutableList.of((Object)((Object)GrenadeSkins.NONE));

    public static boolean isSpecialPerson(UUID uuid) {
        return specialPersons.containsKey((Object)uuid);
    }

    public static ImmutableList<GrenadeSkins> getRewards(UUID uuid) {
        return (ImmutableList)specialPersons.getOrDefault((Object)uuid, DEFAULT_SKINS);
    }

    public static void setSelectedGrenadeSkin(NetHandlerPlayServer playerHandler, GrenadeSkins skin) {
        if (SpecialRewardChecker.isSpecialPerson(playerHandler.field_147369_b.func_110124_au()) && SpecialRewardChecker.getRewards(playerHandler.field_147369_b.func_110124_au()).contains((Object)skin)) {
            playerSelectedSkins.put(playerHandler, skin);
        }
    }

    public static GrenadeSkins getSelectedSkin(EntityPlayer player) {
        if (player == null) {
            return GrenadeSkins.NONE;
        }
        GrenadeSkins playerChoice = player instanceof EntityPlayerMP ? playerSelectedSkins.get(((EntityPlayerMP)player).field_71135_a) : GasPunk.proxy.getSelectedSkin();
        return SpecialRewardChecker.getRewards(player.func_110124_au()).contains((Object)playerChoice) ? playerChoice : GrenadeSkins.NONE;
    }

    public static void retrieveSpecialRewards() {
        try {
            String inputLine;
            Gson GSON = new Gson();
            URLConnection rewardPage = new URL("https://github.com/Ladysnake/ModWinder/raw/master/gaspunkusers.json").openConnection();
            rewardPage.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(rewardPage.getInputStream()));
            StringBuilder jsonString = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                jsonString.append(inputLine);
            }
            in.close();
            Type listType = new TypeToken<Map<String, List<String>>>(){}.getType();
            Map uuidList = (Map)GSON.fromJson(jsonString.toString(), listType);
            specialPersons = (ImmutableMap)uuidList.entrySet().stream().map(SpecialRewardChecker::deserializeEntry).filter(Objects::nonNull).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
            GasPunk.proxy.onSpecialRewardsRetrieved();
        }
        catch (IOException e) {
            GasPunk.LOGGER.warn("Could not connect to LadySnake's reward page. Maybe you're offline ?", (Throwable)e);
        }
        catch (JsonParseException e) {
            GasPunk.LOGGER.error("Bad json coming from LadySnake's reward page. This should be reported.", (Throwable)e);
        }
    }

    @Nullable
    private static Pair<UUID, ImmutableList<GrenadeSkins>> deserializeEntry(Map.Entry<String, List<String>> entry) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)GrenadeSkins.NONE);
        try {
            entry.getValue().stream().map(String::toUpperCase).map(GrenadeSkins::valueOf).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return Pair.of((Object)UUID.fromString(entry.getKey()), (Object)builder.build());
        }
        catch (IllegalArgumentException e) {
            GasPunk.LOGGER.error("Invalid Skin: Either an UUID is wrong or you're using an outdated version. If you do have the latest version, please report this issue", (Throwable)e);
            return null;
        }
    }
}

