/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.sickness;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.List;
import ladysnake.gaspunk.init.ModSicknesses;
import ladysnake.gaspunk.sickness.SicknessGas;
import ladysnake.pathos.api.SicknessEffect;
import ladysnake.pathos.api.event.SicknessEvent;
import ladysnake.pathos.capability.CapabilitySickness;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SicknessTearGas
extends SicknessGas {
    public SicknessTearGas() {
        super(0.001f);
    }

    @Override
    public boolean isSynchronized() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventBusSubscriber(modid="gaspunk", value={Side.CLIENT})
    public static class ClientTearEffect {
        private static MethodHandle _listShaders;

        @SubscribeEvent
        public static void onSicknessAdd(SicknessEvent.SicknessAddEvent event) {
            if (!event.getEntity().field_70170_p.field_72995_K || !(event.getEffect().getSickness() instanceof SicknessTearGas)) {
                return;
            }
            EntityRenderer er = Minecraft.func_71410_x().field_71460_t;
            if (!er.func_147702_a()) {
                er.func_175069_a(new ResourceLocation("shaders/post/fade_in_blur.json"));
            }
        }

        @SubscribeEvent
        public static void onRenderTick(TickEvent.RenderTickEvent event) {
            if (_listShaders != null && event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71460_t.func_147702_a()) {
                float progress = CapabilitySickness.getHandler((Entity)Minecraft.func_71410_x().field_71439_g).map(h -> h.getActiveEffect(ModSicknesses.EYE_IRRITATION)).map(ClientTearEffect::getProgress).orElse(Float.valueOf(0.0f)).floatValue();
                ShaderGroup sg = Minecraft.func_71410_x().field_71460_t.func_147706_e();
                try {
                    List shaders = _listShaders.invoke(sg);
                    for (Shader s : shaders) {
                        ShaderUniform su = s.func_148043_c().func_147991_a("GaspunkProgress");
                        if (su == null) continue;
                        su.func_148090_a(progress);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        private static float getProgress(SicknessEffect effect) {
            return effect == null ? 0.0f : effect.getSeverity() * 2.0f;
        }

        static {
            try {
                Field f = ReflectionHelper.findField(ShaderGroup.class, (String[])new String[]{"field_148031_d", "listShaders"});
                _listShaders = MethodHandles.lookup().unreflectGetter(f);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

