/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.init;

import com.google.common.collect.ImmutableList;
import ladysnake.gaspunk.api.AbstractGas;
import ladysnake.gaspunk.api.IGas;
import ladysnake.gaspunk.api.IGasType;
import ladysnake.gaspunk.api.basetype.GasParticleTypes;
import ladysnake.gaspunk.api.basetype.GasTypes;
import ladysnake.gaspunk.api.event.AgentRegistryEvent;
import ladysnake.gaspunk.gas.Gas;
import ladysnake.gaspunk.gas.GasAgents;
import ladysnake.gaspunk.gas.SuspendableGas;
import ladysnake.gaspunk.gas.agent.CandyflossAgent;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="gaspunk")
@GameRegistry.ObjectHolder(value="gaspunk")
public class ModGases {
    public static IForgeRegistry<IGas> REGISTRY;
    public static final Gas AIR;
    public static final Gas SMOKE;
    public static final Gas TEAR_GAS;
    public static final Gas CHOKE_SMOKE;
    public static final Gas MUSTARD_GAS;

    @SubscribeEvent
    public static void addRegistries(RegistryEvent.NewRegistry event) {
        REGISTRY = new RegistryBuilder().setType(IGas.class).setName(new ResourceLocation("gaspunk", "gases")).setDefaultKey(new ResourceLocation("air")).create();
    }

    @SubscribeEvent
    public static void addAgents(AgentRegistryEvent event) {
        event.register("candyfloss", new CandyflossAgent());
    }

    @SubscribeEvent
    public static void addGases(RegistryEvent.Register<PotionType> event) {
        REGISTRY.register(new SuspendableGas((IGasType)GasTypes.GAS, 0xFFFFFF, GasAgents.getAgent(new ResourceLocation("gaspunk", "nerve")), 0.8f).setRegistryName("sarin_gas"));
        REGISTRY.register(new Gas((IGasType)GasTypes.GAS, GasParticleTypes.GAS, -1711276033, -1442827265, (ImmutableList<AbstractGas.AgentEffect>)ImmutableList.of(), new String[0]).setRegistryName("air"));
        for (EnumDyeColor color : EnumDyeColor.values()) {
            REGISTRY.register(new Gas((IGasType)GasTypes.SMOKE, 0xFF000000 | (Integer)ReflectionHelper.getPrivateValue(EnumDyeColor.class, (Object)color, (String[])new String[]{"colorValue", "field_193351_w"}), new AbstractGas.AgentEffect[0]).setRegistryName("colored_smoke_" + color.func_176610_l()));
        }
    }

    @SubscribeEvent
    public static void onRegistryMissingMappings(RegistryEvent.MissingMappings<IGas> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (!mapping.key.equals((Object)new ResourceLocation("gaspunk:toxic_smoke"))) continue;
            mapping.remap((IForgeRegistryEntry)CHOKE_SMOKE);
        }
    }

    static {
        SMOKE = AIR = null;
        TEAR_GAS = AIR;
        CHOKE_SMOKE = AIR;
        MUSTARD_GAS = AIR;
    }
}

