/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.gas.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import ladysnake.gaspunk.GasPunk;
import ladysnake.gaspunk.api.AbstractGas;
import ladysnake.gaspunk.api.IGas;
import ladysnake.gaspunk.api.IGasAgent;
import ladysnake.gaspunk.api.basetype.GasParticleTypes;
import ladysnake.gaspunk.api.basetype.GasTypes;
import ladysnake.gaspunk.gas.Gas;
import ladysnake.gaspunk.gas.GasAgents;
import ladysnake.gaspunk.init.ModGases;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

@Mod.EventBusSubscriber(modid="gaspunk")
public class GasDeserializer
extends TypeAdapter<AbstractGas> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @SubscribeEvent
    public static void loadGases(RegistryEvent.Register<IGas> event) {
        ModContainer gaspunkContainer = Loader.instance().activeModContainer();
        Loader.instance().getActiveModList().forEach(GasDeserializer::loadGases);
        Loader.instance().setActiveModContainer(gaspunkContainer);
        File configFolder = new File(Loader.instance().getConfigDir(), "gaspunk/custom_gases");
        try {
            if (!configFolder.mkdirs() && configFolder.exists()) {
                Files.walk(configFolder.toPath(), new FileVisitOption[0]).forEach(path -> GasDeserializer.loadGases(configFolder.toPath(), path));
            } else if (configFolder.exists()) {
                Gas exampleGas = new Gas.Builder().addAgent(GasAgents.getAgent(new ResourceLocation("gaspunk", "lachrymator")), 0.5f).addAgent(GasAgents.getAgent(new ResourceLocation("gaspunk", "nerve")), 0.375f).setColor(1439366758).setBottleColor(1977277712).setType(GasTypes.GAS).addTooltipLine("For more examples, check the technical wiki:").addTooltipLine("https://github.com/Ladysnake/Gaspunk/wiki").build();
                Files.write(configFolder.toPath().resolve("_example.json"), GSON.toJson((Object)exampleGas).getBytes(), StandardOpenOption.CREATE_NEW);
            }
        }
        catch (IOException e) {
            GasPunk.LOGGER.error("Error while loading gases from config", (Throwable)e);
        }
    }

    private static void loadGases(ModContainer container) {
        Loader.instance().setActiveModContainer(container);
        CraftingHelper.findFiles((ModContainer)container, (String)("assets/" + container.getModId() + "/gaspunk_gases"), p -> true, GasDeserializer::loadGases, (boolean)true, (boolean)true);
    }

    private static boolean loadGases(Path root, Path file) {
        String relative = root.relativize(file).toString();
        if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
            return true;
        }
        String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
        try (BufferedReader reader = Files.newBufferedReader(file);){
            Gas gas = (Gas)GSON.fromJson((Reader)reader, Gas.class);
            ModGases.REGISTRY.register(gas.setRegistryName(name));
        }
        catch (Exception e) {
            GasPunk.LOGGER.error((Message)new FormattedMessage("Error trying to load a gas from file {}", (Object)file), (Throwable)e);
        }
        return true;
    }

    public void write(JsonWriter out, AbstractGas value) throws IOException {
        out.beginObject();
        if (!(value.getType() instanceof GasTypes)) {
            throw new RuntimeException("Cannot serialize unknown type " + value.getType());
        }
        Enum type = (GasTypes)value.getType();
        out.name("gasType");
        out.value(type.name());
        if (!(value.getParticleType() instanceof GasParticleTypes)) {
            throw new RuntimeException("Cannot serialize unknown type " + value.getParticleType());
        }
        type = (GasParticleTypes)value.getParticleType();
        out.name("particleType");
        out.value(type.name());
        out.name("color");
        out.value(Long.toString(value.getColor(), 16));
        out.name("bottleColor");
        out.value(Long.toString(value.getBottleColor(), 16));
        out.name("agents");
        out.beginArray();
        for (AbstractGas.AgentEffect effect : value.getAgents()) {
            out.beginObject();
            out.name("agent");
            out.value(GasAgents.getId(effect.getAgent()).toString());
            out.name("potency");
            out.value((double)effect.getPotency());
            out.endObject();
        }
        out.endArray();
        String[] tooltipLines = value.getTooltipLines();
        if (tooltipLines.length > 0) {
            out.name("tooltipLines");
            out.beginArray();
            for (String s : value.getTooltipLines()) {
                out.value(s);
            }
            out.endArray();
        }
        out.endObject();
    }

    public AbstractGas read(JsonReader in) throws IOException {
        AbstractGas.Builder builder = AbstractGas.builder();
        in.beginObject();
        while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "gasType": {
                    builder.setType(GasTypes.valueOf(in.nextString()));
                    break;
                }
                case "particleType": {
                    builder.setParticleType(GasParticleTypes.valueOf(in.nextString()));
                    break;
                }
                case "color": {
                    builder.setColor(this.parseInt(in, "color"));
                    break;
                }
                case "bottleColor": {
                    builder.setBottleColor(this.parseInt(in, "bottleColor"));
                    break;
                }
                case "agents": {
                    this.parseAgents(in, builder);
                    break;
                }
                case "tooltipLines": {
                    this.parseTooltip(in, builder);
                }
            }
        }
        in.endObject();
        return builder.build();
    }

    private void parseTooltip(JsonReader in, AbstractGas.Builder builder) throws IOException {
        in.beginArray();
        while (in.hasNext()) {
            builder.addTooltipLine(in.nextString());
        }
        in.endArray();
    }

    private int parseInt(JsonReader in, String memberName) throws IOException {
        String value = in.nextString();
        try {
            return Long.decode(value).intValue();
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException("Expected " + memberName + " to be a valid Int representation, was " + value, (Throwable)e);
        }
    }

    private void parseAgents(JsonReader in, AbstractGas.Builder builder) throws IOException {
        in.beginArray();
        while (in.hasNext()) {
            IGasAgent agent = null;
            double potency = 0.0;
            in.beginObject();
            while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "agent": {
                        String id = in.nextString();
                        agent = GasAgents.getAgent(new ResourceLocation(id));
                        if (agent != null) break;
                        throw new JsonParseException("Invalid agent provided: " + id + " " + in.getPath());
                    }
                    case "potency": {
                        potency = in.nextDouble();
                    }
                }
            }
            in.endObject();
            builder.addAgent(Objects.requireNonNull(agent, "no agent type provided"), (float)potency);
        }
        in.endArray();
    }
}

