/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.gas.core;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ladysnake.gaspunk.GasPunkConfig;
import ladysnake.gaspunk.api.IBreathingHandler;
import ladysnake.gaspunk.api.IGas;
import ladysnake.gaspunk.api.event.GasEvent;
import ladysnake.gaspunk.gas.core.PlayerBreathingHandler;
import ladysnake.gaspunk.item.ItemGasMask;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Mod.EventBusSubscriber(modid="gaspunk")
public class CapabilityBreathing {
    private static final MethodHandle entityLivingBase$decreaseAirSupply;
    public static final IAttribute MAX_AIR_SUPPLY;
    @CapabilityInject(value=IBreathingHandler.class)
    public static Capability<IBreathingHandler> CAPABILITY_BREATHING;

    public static void register() {
        CapabilityManager.INSTANCE.register(IBreathingHandler.class, (Capability.IStorage)new Storage(), DefaultBreathingHandler::new);
    }

    public static Optional<IBreathingHandler> getHandler(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            return Optional.ofNullable(entity.getCapability(CAPABILITY_BREATHING, null));
        }
        return Optional.empty();
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLivingBase) {
            event.addCapability(new ResourceLocation("gaspunk", "breathing_cap"), (ICapabilityProvider)new Provider((EntityLivingBase)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        CapabilityBreathing.getHandler(event.getEntity()).ifPresent(IBreathingHandler::tick);
    }

    static {
        MAX_AIR_SUPPLY = new RangedAttribute(null, "gaspunk.maxAirSupply", 300.0, 0.0, 1024.0).func_111117_a("Max Air Supply").func_111112_a(true);
        MethodHandle temp = null;
        try {
            Method method = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"decreaseAirSupply", (String)"func_70682_h", (Class[])new Class[]{Integer.TYPE});
            temp = MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        entityLivingBase$decreaseAirSupply = temp;
    }

    public static class Storage
    implements Capability.IStorage<IBreathingHandler> {
        @Nullable
        public NBTBase writeNBT(Capability<IBreathingHandler> capability, IBreathingHandler instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74776_a("breath", instance.getAirSupply());
            return nbt;
        }

        public void readNBT(Capability<IBreathingHandler> capability, IBreathingHandler instance, EnumFacing side, NBTBase nbt) {
            instance.setAirSupply(((NBTTagCompound)nbt).func_74760_g("breath"));
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        final IBreathingHandler instance;

        Provider(EntityLivingBase object) {
            int maxAir = object instanceof EntityPlayer ? 300 : (object instanceof INpc ? 200 : 40);
            object.func_110140_aT().func_111150_b(MAX_AIR_SUPPLY).func_111128_a((double)maxAir);
            this.instance = object instanceof EntityPlayerMP ? new PlayerBreathingHandler((EntityPlayerMP)object) : new DefaultBreathingHandler(object);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAPABILITY_BREATHING;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CAPABILITY_BREATHING ? CAPABILITY_BREATHING.cast((Object)this.instance) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)CAPABILITY_BREATHING.getStorage().writeNBT(CAPABILITY_BREATHING, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            CAPABILITY_BREATHING.getStorage().readNBT(CAPABILITY_BREATHING, (Object)this.instance, null, (NBTBase)nbt);
        }
    }

    public static class DefaultBreathingHandler
    implements IBreathingHandler {
        protected float airSupply;
        protected final EntityLivingBase owner;
        protected final Map<IGas, Float> prevConcentrations = new HashMap<IGas, Float>();
        protected final Map<IGas, Float> concentrations = new HashMap<IGas, Float>();

        DefaultBreathingHandler() {
            this(null);
        }

        public DefaultBreathingHandler(EntityLivingBase owner) {
            this.owner = owner;
            this.airSupply = this.getMaxAirSupply();
        }

        @Override
        public void setConcentration(IGas gas, float concentration) {
            if (this.concentrations.getOrDefault(gas, Float.valueOf(0.0f)).floatValue() < concentration) {
                this.concentrations.put(gas, Float.valueOf(concentration));
            }
        }

        @Override
        public Map<IGas, Float> getGasConcentrations() {
            return this.concentrations;
        }

        @Override
        public void tick() {
            if (!this.owner.field_70170_p.field_72995_K) {
                this.prevConcentrations.forEach((gas, concentration) -> {
                    if (!this.concentrations.containsKey(gas)) {
                        if (MinecraftForge.EVENT_BUS.post((Event)new GasEvent.ExitGasCloudEvent(this.owner, this, (IGas)gas, concentration.floatValue()))) {
                            this.concentrations.put((IGas)gas, (Float)concentration);
                        } else {
                            gas.onExitCloud(this.owner, this);
                        }
                    }
                });
                boolean appliedAirReduction = false;
                float entityModifier = 1.0f;
                if (entityLivingBase$decreaseAirSupply != null) {
                    try {
                        entityModifier = this.airSupply - (float)entityLivingBase$decreaseAirSupply.invoke(this.owner, (int)this.airSupply);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                for (Map.Entry<IGas, Float> gasEffect : this.concentrations.entrySet()) {
                    boolean firstTick;
                    float concentration2;
                    IGas gas2 = gasEffect.getKey();
                    if (this.isImmune(gas2, concentration2 = gasEffect.getValue().floatValue() * entityModifier)) continue;
                    boolean bl = firstTick = !this.prevConcentrations.containsKey(gasEffect.getKey());
                    if (firstTick) {
                        MinecraftForge.EVENT_BUS.post((Event)new GasEvent.GasEnterEvent(this.owner, this, gas2, concentration2));
                    }
                    if (MinecraftForge.EVENT_BUS.post((Event)new GasEvent.GasTickEvent(this.owner, this, gas2, concentration2))) continue;
                    if (gas2.isToxic()) {
                        if (this.airSupply > 0.0f && !appliedAirReduction) {
                            this.setAirSupply(this.airSupply - 2.0f);
                        }
                        appliedAirReduction = true;
                    }
                    gas2.applyEffect(this.owner, this, concentration2, firstTick);
                }
                this.prevConcentrations.clear();
                this.prevConcentrations.putAll(this.concentrations);
                if (!appliedAirReduction && this.airSupply < this.getMaxAirSupply()) {
                    this.setAirSupply(this.airSupply + 2.0f);
                }
            }
            this.concentrations.clear();
        }

        @Override
        public boolean isImmune(IGas gas, float concentration) {
            Item helmet = this.owner.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b();
            boolean immune = helmet instanceof ItemGasMask;
            for (String alt : GasPunkConfig.otherGasMasks) {
                String[] suit = alt.split("&");
                boolean fullSuit = true;
                switch (suit.length) {
                    case 4: {
                        fullSuit = suit[3].equals("*") || suit[3].equals(String.valueOf(this.owner.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b().getRegistryName()));
                    }
                    case 3: {
                        fullSuit &= suit[2].equals("*") || suit[2].equals(String.valueOf(this.owner.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b().getRegistryName()));
                    }
                    case 2: {
                        fullSuit &= suit[1].equals("*") || suit[1].equals(String.valueOf(this.owner.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b().getRegistryName()));
                    }
                    case 1: {
                        fullSuit &= suit[0].equals("*") || suit[0].equals(String.valueOf(this.owner.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b().getRegistryName()));
                    }
                }
                immune |= fullSuit;
            }
            GasEvent.GasImmunityEvent event = new GasEvent.GasImmunityEvent(this.owner, this, gas, concentration, immune);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.isImmune();
        }

        @Override
        public float getAirSupply() {
            return this.airSupply;
        }

        @Override
        public void setAirSupply(float airSupply) {
            this.airSupply = Math.min(airSupply, this.getMaxAirSupply());
        }

        protected float getMaxAirSupply() {
            return (float)this.owner.func_110148_a(MAX_AIR_SUPPLY).func_111126_e();
        }
    }
}

