/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.gas.agent;

import ladysnake.gaspunk.GasPunk;
import ladysnake.gaspunk.api.IBreathingHandler;
import ladysnake.gaspunk.gas.agent.GasAgent;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PotionAgent
extends GasAgent {
    private Potion potion;
    private ResourceLocation potionId;
    private int potionDuration;
    private int potionAmplifier;

    public PotionAgent(ResourceLocation potion, int potionDuration, int potionAmplifier) {
        super(true);
        this.potionId = potion;
        this.potionDuration = potionDuration;
        this.potionAmplifier = potionAmplifier;
    }

    public Potion getPotion() {
        if (this.potion == null) {
            this.potion = (Potion)ForgeRegistries.POTIONS.getValue(this.potionId);
            if (this.potion == null) {
                GasPunk.LOGGER.warn("Potion gas agent {} is linked to invalid potion id {}", (Object)this.getRegistryName(), (Object)this.potionId);
                return MobEffects.field_188425_z;
            }
            this.toxic = this.potion.func_76398_f();
        }
        return this.potion;
    }

    @Override
    public void applyEffect(EntityLivingBase entity, IBreathingHandler handler, float concentration, boolean firstTick, float potency, boolean forced) {
        if (!entity.field_70170_p.field_72995_K && (forced || entity.field_70170_p.func_72820_D() % 20L == 0L)) {
            Potion potion = this.getPotion();
            entity.func_70690_d(new PotionEffect(potion, this.potionDuration, this.potionAmplifier));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[]{I18n.func_135052_a((String)this.getPotion().func_76393_a(), (Object[])new Object[0])});
    }
}

