/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.entity;

import javax.annotation.Nonnull;
import ladylib.misc.ItemUtil;
import ladysnake.gaspunk.GasPunk;
import ladysnake.gaspunk.entity.EntityGasCloud;
import ladysnake.gaspunk.entity.EntityNonRetardedThrowable;
import ladysnake.gaspunk.init.ModItems;
import ladysnake.gaspunk.item.ItemGrenade;
import ladysnake.gaspunk.item.SkinItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityGrenade
extends EntityNonRetardedThrowable {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntityGrenade.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> COUNTDOWN = EntityDataManager.func_187226_a(EntityGrenade.class, (DataSerializer)DataSerializers.field_187192_b);
    protected int cloudMaxLifeSpan;
    protected boolean canPickup;

    public EntityGrenade(World worldIn) {
        super(worldIn);
    }

    public EntityGrenade(World worldIn, ItemStack stack, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.setItem(stack);
        this.canPickup = true;
    }

    public EntityGrenade(World worldIn, @Nonnull EntityLivingBase throwerIn, ItemStack stack) {
        super(worldIn, throwerIn);
        this.setItem(stack);
        this.canPickup = !(throwerIn instanceof EntityPlayer) || !((EntityPlayer)throwerIn).func_184812_l_();
    }

    @Override
    protected float getGravityVelocity() {
        return 0.05f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ITEM, (Object)new ItemStack(ModItems.GRENADE));
        this.func_184212_Q().func_187214_a(COUNTDOWN, (Object)60);
    }

    public void setCountdown(int countdown) {
        this.func_184212_Q().func_187227_b(COUNTDOWN, (Object)countdown);
    }

    private int getCountdown() {
        return (Integer)this.func_184212_Q().func_187225_a(COUNTDOWN);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int countdown = this.getCountdown();
        if (countdown == 1) {
            this.explode();
        }
        this.setCountdown(this.getCountdown() - 1);
        if (countdown <= -this.cloudMaxLifeSpan) {
            if (this.canPickup) {
                ItemStack stack = this.getGrenade();
                ItemGrenade grenadeItem = (ItemGrenade)stack.func_77973_b();
                ItemStack emptyGrenade = new ItemStack(ModItems.EMPTY_GRENADE);
                ((SkinItem)ModItems.EMPTY_GRENADE).setSkin(emptyGrenade, grenadeItem.getSkin(stack));
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, emptyGrenade));
            }
            this.func_70106_y();
        }
    }

    @Nonnull
    public ItemStack getGrenade() {
        ItemStack itemstack = (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
        if (!(itemstack.func_77973_b() instanceof ItemGrenade)) {
            if (this.field_70170_p != null) {
                GasPunk.LOGGER.error("{} {} has no item?!", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.func_145782_y());
            }
            return new ItemStack(ModItems.GRENADE);
        }
        return itemstack;
    }

    public void setItem(ItemStack item) {
        ItemUtil.getOrCreateCompound((ItemStack)item).func_74757_a("isEntityGrenade", true);
        this.func_184212_Q().func_187227_b(ITEM, (Object)item);
    }

    @Override
    protected void onImpact(@Nonnull RayTraceResult result) {
        if (result.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(result.func_178782_a()).func_185913_b() && this.ignoreTime-- <= 0) {
            Vec3i hitVector = result.field_178784_b.func_176730_m();
            this.field_70159_w *= (double)hitVector.func_177958_n() * -0.4 + 0.2;
            if (Math.abs(this.field_70159_w) < 0.2) {
                this.field_70159_w = 0.0;
            }
            this.field_70181_x *= (double)hitVector.func_177956_o() * -0.4 + 0.2;
            if (Math.abs(this.field_70181_x) < 0.3) {
                this.field_70181_x = 0.0;
            }
            this.field_70179_y *= (double)hitVector.func_177952_p() * -0.4 + 0.2;
            if (Math.abs(this.field_70179_y) < 0.2) {
                this.field_70179_y = 0.0;
            }
            this.ignoreTime = 2;
            this.field_70160_al = true;
        } else if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
            this.field_70159_w *= -0.05;
            this.field_70181_x *= -0.05;
            this.field_70179_y *= -0.05;
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
        }
    }

    protected void explode() {
        if (this.field_70170_p instanceof WorldServer) {
            EntityGasCloud cloud = ((ItemGrenade)this.getGrenade().func_77973_b()).explode((WorldServer)this.field_70170_p, this.func_174791_d(), this.getGrenade());
            cloud.setEmitter(this);
            this.cloudMaxLifeSpan = cloud.getMaxLifeSpan();
        }
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("countdown", this.getCountdown());
        compound.func_74768_a("cloudMaxLifeSpan", this.cloudMaxLifeSpan);
        compound.func_74782_a("grenade", (NBTBase)this.getGrenade().func_77955_b(new NBTTagCompound()));
        compound.func_74757_a("canPickup", this.canPickup);
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setCountdown(compound.func_74762_e("countdown"));
        this.cloudMaxLifeSpan = compound.func_74762_e("cloudMaxLifeSpan");
        this.setItem(new ItemStack(compound.func_74775_l("grenade")));
        this.canPickup = compound.func_74767_n("canPickup");
    }
}

