/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ladysnake.gaspunk.GasPunk;
import ladysnake.gaspunk.GasPunkConfig;
import ladysnake.gaspunk.api.IGas;
import ladysnake.gaspunk.gas.core.CapabilityBreathing;
import ladysnake.gaspunk.init.ModGases;
import ladysnake.gaspunk.util.GasUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityGasCloud
extends Entity
implements IEntityAdditionalSpawnData {
    static int maxPropDistance;
    public static final int MAX_PROPAGATION_DISTANCE;
    public static final int MAX_PROPAGATION_DISTANCE_SQ;
    private static final DataParameter<Integer> CLOUD_AGE;
    private static final DataParameter<Integer> MAX_LIFESPAN;
    protected IGas gas = ModGases.AIR;
    @Nullable
    protected UUID emitterID;

    public EntityGasCloud(World worldIn) {
        super(worldIn);
    }

    public EntityGasCloud(World worldIn, IGas gas) {
        this(worldIn);
        this.gas = gas;
    }

    public void setEmitter(@Nullable Entity emitter) {
        this.emitterID = emitter == null ? null : emitter.func_110124_au();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        float ageRatio = 1.0f - (float)this.getCloudAge() / (float)this.getMaxLifeSpan();
        int particleAmount = this.gas.getParticleType().getParticleAmount();
        int color = this.gas.getColor();
        if (this.getCloudAge() % 10 == 0) {
            GasPunk.proxy.makeSmoke(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, color, particleAmount, MAX_PROPAGATION_DISTANCE - 2, 2, this.gas.getParticleType());
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity emitter;
            if (this.emitterID != null && (emitter = ((WorldServer)this.field_70170_p).func_175733_a(this.emitterID)) != null) {
                this.func_70107_b(emitter.field_70165_t, emitter.field_70163_u, emitter.field_70161_v);
            }
            int age = this.getCloudAge();
            this.setCloudAge(age + 1);
            if (age > this.getMaxLifeSpan()) {
                this.func_70106_y();
                return;
            }
        }
        AxisAlignedBB box = new AxisAlignedBB(new BlockPos((Entity)this)).func_186662_g(10.0);
        List entities = this.field_70170_p.field_72995_K ? this.field_70170_p.func_175661_b(EntityPlayer.class, p -> p != null && this.func_70068_e((Entity)p) < (double)MAX_PROPAGATION_DISTANCE_SQ) : this.field_70170_p.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase entity : entities) {
            float f = GasPunkConfig.fastGas ? this.func_70032_d((Entity)entity) : (float)GasUtil.getPropagationDistance(this.field_70170_p, new BlockPos((Entity)this), new BlockPos((Entity)entity), MAX_PROPAGATION_DISTANCE);
            float distance = f;
            if (!(distance >= 0.0f)) continue;
            float concentration = ageRatio * (1.0f - distance / (float)MAX_PROPAGATION_DISTANCE);
            CapabilityBreathing.getHandler((Entity)entity).ifPresent(h -> h.setConcentration(this.gas, concentration));
        }
    }

    public int getCloudAge() {
        return (Integer)this.func_184212_Q().func_187225_a(CLOUD_AGE);
    }

    public void setCloudAge(int cloudAge) {
        this.func_184212_Q().func_187227_b(CLOUD_AGE, (Object)cloudAge);
    }

    public int getMaxLifeSpan() {
        return (Integer)this.func_184212_Q().func_187225_a(MAX_LIFESPAN);
    }

    public void setMaxLifespan(int lifespan) {
        this.func_184212_Q().func_187227_b(MAX_LIFESPAN, (Object)lifespan);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(CLOUD_AGE, (Object)0);
        this.func_184212_Q().func_187214_a(MAX_LIFESPAN, (Object)100);
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        this.gas = (IGas)ModGases.REGISTRY.getValue(new ResourceLocation(compound.func_74779_i("gas")));
        this.setMaxLifespan(compound.func_74762_e("max_lifespan"));
        this.setCloudAge(compound.func_74762_e("cloud_age"));
        if (compound.func_74764_b("emitter_idLeast")) {
            this.emitterID = compound.func_186857_a("emitter_id");
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        if (this.gas != null) {
            compound.func_74778_a("gas", Objects.requireNonNull(this.gas.getRegistryName()).toString());
        }
        compound.func_74768_a("max_lifespan", this.getMaxLifeSpan());
        compound.func_74768_a("cloud_age", this.getCloudAge());
        if (this.emitterID != null) {
            compound.func_186854_a("emitter_id", this.emitterID);
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        PacketBuffer buf = new PacketBuffer(buffer);
        buf.func_180714_a(this.gas != null ? Objects.requireNonNull(this.gas.getRegistryName()).toString() : "");
    }

    public void readSpawnData(ByteBuf additionalData) {
        PacketBuffer buf = new PacketBuffer(additionalData);
        this.gas = (IGas)ModGases.REGISTRY.getValue(new ResourceLocation(buf.func_150789_c(64)));
    }

    static {
        MAX_PROPAGATION_DISTANCE = maxPropDistance = GasPunkConfig.maxPropagationDistance;
        MAX_PROPAGATION_DISTANCE_SQ = MAX_PROPAGATION_DISTANCE * MAX_PROPAGATION_DISTANCE;
        CLOUD_AGE = EntityDataManager.func_187226_a(EntityGasCloud.class, (DataSerializer)DataSerializers.field_187192_b);
        MAX_LIFESPAN = EntityDataManager.func_187226_a(EntityGasCloud.class, (DataSerializer)DataSerializers.field_187192_b);
    }
}

