/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.compat;

import java.util.ArrayList;
import java.util.List;
import ladysnake.gaspunk.api.IGas;
import ladysnake.gaspunk.api.customization.GrenadeSkins;
import ladysnake.gaspunk.init.ModGases;
import ladysnake.gaspunk.init.ModItems;
import ladysnake.gaspunk.item.ItemGasTube;
import ladysnake.gaspunk.item.ItemGrenade;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.brewing.AbstractBrewingRecipe;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;

public class ThaumcraftCompat {
    public static void registerAspects() {
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(ModItems.SULFUR), (AspectList)new AspectList().add(Aspect.FIRE, 10).add(Aspect.EARTH, 8).add(Aspect.ENTROPY, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(ModItems.ASH), (AspectList)new AspectList().add(Aspect.FIRE, 7).add(Aspect.ENTROPY, 5).add(Aspect.DEATH, 10));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(ModItems.GRENADE), (AspectList)new AspectList(new ItemStack(ModItems.DIFFUSER)).add(Aspect.ALCHEMY, 5).add(Aspect.ENERGY, 7).add(Aspect.AIR, 7));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(ModItems.SMOKE_POWDER), (AspectList)new AspectList().add(ThaumcraftCompat.divide(AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151016_H)), 1.5)).add(Aspect.SENSES, 10).add(Aspect.AIR, 6));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(ModItems.EMPTY_GRENADE), (AspectList)new AspectList(new ItemStack(ModItems.DIFFUSER)).add(Aspect.VOID, 8));
        ThaumcraftCompat.registerGasAspect(ModGases.SMOKE, new AspectList());
        for (IGas gas : ModGases.REGISTRY.getValues()) {
            ThaumcraftCompat.registerGasAspect(gas, new AspectList());
        }
    }

    private static AspectList generateAspectsFromBrewing(ItemStack stack) {
        ArrayList<AspectList> all = new ArrayList<AspectList>();
        for (IBrewingRecipe recipe : BrewingRecipeRegistry.getRecipes()) {
            ItemStack output;
            if (!(recipe instanceof AbstractBrewingRecipe) || ItemGasTube.getContainedGas(output = ((AbstractBrewingRecipe)recipe).getOutput()) != ItemGasTube.getContainedGas(stack)) continue;
            AspectList aspects = new AspectList();
            aspects.add(AspectHelper.getObjectAspects((ItemStack)((AbstractBrewingRecipe)recipe).getInput()));
            if (recipe instanceof BrewingRecipe) {
                aspects.add(AspectHelper.getObjectAspects((ItemStack)((ItemStack)((BrewingRecipe)recipe).getIngredient())));
            } else if (recipe instanceof BrewingOreRecipe) {
                for (ItemStack ingredient : (List)((BrewingOreRecipe)recipe).getIngredient()) {
                    AspectList list = AspectHelper.getObjectAspects((ItemStack)ingredient);
                    for (Aspect aspect : list.getAspects()) {
                        aspects.add(aspect, list.getAmount(aspect) / list.size());
                    }
                }
            }
            all.add(aspects);
        }
        AspectList ret = new AspectList();
        for (AspectList list : all) {
            for (Aspect aspect : list.getAspects()) {
                ret.add(aspect, list.getAmount(aspect) / all.size());
            }
        }
        return AspectHelper.cullTags((AspectList)ret);
    }

    private static AspectList divide(AspectList aspects, double amount) {
        AspectList ret = new AspectList();
        if (aspects != null) {
            for (Aspect a : aspects.getAspects()) {
                ret.add(a, MathHelper.func_76128_c((double)((double)aspects.getAmount(a) / amount)));
            }
        }
        return ret;
    }

    private static void registerGasAspect(IGas gas, AspectList aspects) {
        ItemStack gasTube = ((ItemGasTube)ModItems.GAS_TUBE).getItemStackFor(gas);
        aspects.add(ThaumcraftCompat.divide(ThaumcraftCompat.generateAspectsFromBrewing(gasTube), 1.1));
        ThaumcraftApi.registerObjectTag((ItemStack)gasTube, (AspectList)aspects.copy());
        ItemStack grenade = ((ItemGrenade)ModItems.GRENADE).getItemStackFor(gas);
        aspects.add(ThaumcraftCompat.divide(AspectHelper.getObjectAspects((ItemStack)new ItemStack(ModItems.GRENADE)), 1.8));
        for (GrenadeSkins skin : GrenadeSkins.VALUES) {
            ((ItemGrenade)ModItems.GRENADE).setSkin(grenade, skin);
            ThaumcraftApi.registerObjectTag((ItemStack)grenade, (AspectList)aspects.copy());
        }
    }
}

