/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.api.event;

import ladysnake.gaspunk.api.IBreathingHandler;
import ladysnake.gaspunk.api.IGas;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;

public class GasEvent
extends LivingEvent {
    protected final IBreathingHandler breathHandler;
    protected final IGas gas;
    protected final float concentration;

    public GasEvent(EntityLivingBase entity, IBreathingHandler breathHandler, IGas gas, float concentration) {
        super(entity);
        this.breathHandler = breathHandler;
        this.gas = gas;
        this.concentration = concentration;
    }

    public IBreathingHandler getBreathHandler() {
        return this.breathHandler;
    }

    public IGas getGas() {
        return this.gas;
    }

    public float getConcentration() {
        return this.concentration;
    }

    public static class GasImmunityEvent
    extends GasEvent {
        private boolean immune;

        public GasImmunityEvent(EntityLivingBase entity, IBreathingHandler breathHandler, IGas gas, float concentration, boolean immune) {
            super(entity, breathHandler, gas, concentration);
            this.immune = immune;
        }

        public boolean isImmune() {
            return this.immune;
        }

        public void setImmune(boolean immune) {
            this.immune = immune;
        }
    }

    @Cancelable
    public static class ExitGasCloudEvent
    extends GasEvent {
        public ExitGasCloudEvent(EntityLivingBase entity, IBreathingHandler breathHandler, IGas gas, float concentration) {
            super(entity, breathHandler, gas, concentration);
        }
    }

    @Cancelable
    public static class GasTickEvent
    extends GasEvent {
        public GasTickEvent(EntityLivingBase entity, IBreathingHandler breathHandler, IGas gas, float concentration) {
            super(entity, breathHandler, gas, concentration);
        }
    }

    public static class GasEnterEvent
    extends GasEvent {
        public GasEnterEvent(EntityLivingBase entity, IBreathingHandler breathHandler, IGas gas, float concentration) {
            super(entity, breathHandler, gas, concentration);
        }
    }
}

