/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.api;

import com.google.common.collect.ImmutableList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import ladysnake.gaspunk.api.IGas;
import ladysnake.gaspunk.api.IGasAgent;
import ladysnake.gaspunk.api.IGasParticleType;
import ladysnake.gaspunk.api.IGasType;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class AbstractGas
extends IForgeRegistryEntry.Impl<IGas>
implements IGas {
    private static Supplier<Builder> builderSupplier;

    @Nonnull
    public static Builder builder() {
        if (builderSupplier == null) {
            throw new IllegalStateException("The gas class has not yet been initialized");
        }
        return builderSupplier.get();
    }

    public abstract ImmutableList<AgentEffect> getAgents();

    public abstract String[] getTooltipLines();

    public static interface Builder {
        public Builder setType(IGasType var1);

        public Builder setParticleType(IGasParticleType var1);

        public Builder setColor(int var1);

        public Builder setBottleColor(int var1);

        public Builder addAgent(IGasAgent var1, float var2);

        public Builder addTooltipLine(String var1);

        public AbstractGas build();
    }

    public static class AgentEffect {
        private final IGasAgent agent;
        private final float potency;

        public AgentEffect(IGasAgent agent, float potency) {
            this.agent = agent;
            this.potency = potency;
        }

        public IGasAgent getAgent() {
            return this.agent;
        }

        public float getPotency() {
            return this.potency;
        }
    }
}

