/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="gaspunk", name="gaspunk/gaspunk")
@Mod.EventBusSubscriber(modid="gaspunk")
public class GasPunkConfig {
    @Config.Comment(value={"Disables gas / smoke / vapor clouds checking for a clear path to entities and make them only check straight distance instead"})
    public static boolean fastGas = false;
    @Config.Comment(value={"Makes ash require smelting nether wart instead of rotten flesh"})
    public static boolean alternativeAshRecipe = false;
    @Config.Comment(value={"Sets the lifespan in ticks for gas clouds. The clouds themselves look like they take a bit longer to decay, but the effects no longer happen after this amount."})
    public static int gasLifespan = 600;
    @Config.Comment(value={"Default distance that the gas cloud travels. The value appears to be an estimate for the radius in meters. I am not the original developer, so I'm not completely sure."})
    public static int maxPropagationDistance = 10;
    @Config.Comment(value={"The items which ID's are added here will be considered as gas masks when breathing gas", "You can specify entire armor sets by separating items with \"&\" in a single entry. Using \"*\" instead of an item id will match anything.", "Examples: \"minecraft:diamond_helmet\", \"minecraft:golden_helmet&*&minecraft:chainmail_leggings\""})
    public static String[] otherGasMasks = new String[0];
    public static Client client = new Client();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("gaspunk")) {
            ConfigManager.sync((String)"gaspunk", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class Client {
        @Config.Comment(value={"Enables the use of shaders to render the gas overlay", "won't do anything if renderGasOverlays is set to false"})
        public boolean useShaders = true;
        @Config.Comment(value={"Display a custom overlay when inside a gas cloud", "combine with useShaders for a dynamically generated overlay"})
        public boolean renderGasOverlays = false;
    }
}

