/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.textfield;

import com.cleanroommc.modularui.drawable.TextRenderer;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.widgets.textfield.TextFieldHandler;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextFieldRenderer
extends TextRenderer {
    protected final TextFieldHandler handler;
    protected int markedColor = 3109544;
    protected boolean renderCursor = false;

    public TextFieldRenderer(TextFieldHandler handler) {
        this.handler = handler;
    }

    public void toggleCursor() {
        this.renderCursor = !this.renderCursor;
    }

    public void setCursor(boolean active) {
        this.renderCursor = active;
    }

    public void setMarkedColor(int markedColor) {
        this.markedColor = markedColor;
    }

    @Override
    protected void drawMeasuredLines(List<TextRenderer.Line> measuredLines) {
        this.drawCursors(measuredLines);
        super.drawMeasuredLines(measuredLines);
    }

    @Override
    public List<String> wrapLine(String line) {
        return Collections.singletonList(line);
    }

    protected void drawCursors(List<TextRenderer.Line> measuredLines) {
        if (!this.simulate) {
            Point2D.Float start;
            if (this.handler.hasTextMarked()) {
                start = this.getPosOf(measuredLines, this.handler.getStartCursor());
                Point2D.Float end = this.getPosOf(measuredLines, this.handler.getEndCursor());
                if (start.y == end.y) {
                    this.drawMarked(start.y, start.x, end.x);
                } else {
                    int min = this.handler.getStartCursor().y;
                    int max = this.handler.getEndCursor().y;
                    TextRenderer.Line line = measuredLines.get(min);
                    int startX = this.getStartX(line.getWidth());
                    this.drawMarked(start.y, start.x, (float)startX + line.getWidth());
                    start.y += this.getFontHeight();
                    if (max - min > 1) {
                        for (int i = min + 1; i < max; ++i) {
                            line = measuredLines.get(i);
                            startX = this.getStartX(line.getWidth());
                            this.drawMarked(start.y, startX, (float)startX + line.getWidth());
                            start.y += this.getFontHeight();
                        }
                    }
                    line = measuredLines.get(max);
                    startX = this.getStartX(line.getWidth());
                    this.drawMarked(start.y, startX, end.x);
                }
            }
            Point main = this.handler.getMainCursor();
            start = this.getPosOf(measuredLines, main);
            if (this.renderCursor) {
                if (this.handler.getText().get(main.y).isEmpty()) {
                    start.x += 0.7f;
                }
                this.drawCursor(start.x, start.y);
            }
        }
    }

    public Point getCursorPos(List<String> lines, int x, int y) {
        if (lines.isEmpty()) {
            return new Point();
        }
        List<TextRenderer.Line> measuredLines = this.measureLines(lines);
        int index = (int)((float)(y -= this.getStartY(measuredLines.size()) + this.y) / this.getFontHeight());
        if (index < 0) {
            return new Point();
        }
        if (index >= measuredLines.size()) {
            return new Point(measuredLines.get(measuredLines.size() - 1).getText().length(), measuredLines.size() - 1);
        }
        TextRenderer.Line line = measuredLines.get(index);
        x -= this.getStartX(line.getWidth()) + this.x;
        if (line.getWidth() <= 0.0f) {
            return new Point(0, index);
        }
        if (line.getWidth() < (float)x) {
            return new Point(line.getText().length(), index);
        }
        float currentX = 0.0f;
        for (int i = 0; i < line.getText().length(); ++i) {
            char c = line.getText().charAt(i);
            if (!((currentX += (float)TextFieldRenderer.getFontRenderer().func_78263_a(c) * this.scale) >= (float)x)) continue;
            return new Point(i, index);
        }
        return new Point();
    }

    public Point2D.Float getPosOf(List<TextRenderer.Line> measuredLines, Point cursorPos) {
        if (measuredLines.isEmpty()) {
            return new Point2D.Float(this.getStartX(0.0f), this.getStartY(1));
        }
        TextRenderer.Line line = measuredLines.get(cursorPos.y);
        String sub = line.getText().substring(0, Math.min(line.getText().length(), cursorPos.x));
        return new Point2D.Float((float)this.getStartX(line.getWidth()) + (float)TextFieldRenderer.getFontRenderer().func_78256_a(sub) * this.scale, (float)this.getStartY(measuredLines.size()) + (float)cursorPos.y * this.getFontHeight());
    }

    @SideOnly(value=Side.CLIENT)
    public void drawMarked(float y0, float x0, float x1) {
        float y1 = (y0 -= 1.0f) + this.getFontHeight();
        float red = Color.getRedF(this.markedColor);
        float green = Color.getGreenF(this.markedColor);
        float blue = Color.getBlueF(this.markedColor);
        float alpha = Color.getAlphaF(this.markedColor);
        if (alpha == 0.0f) {
            alpha = 1.0f;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        GlStateManager.func_179090_x();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)x0, (double)y1, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x1, (double)y1, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x1, (double)y0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x0, (double)y0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    private void drawCursor(float x0, float y0) {
        x0 = (x0 - 0.8f) / this.scale;
        y0 = (y0 - 1.0f) / this.scale;
        float x1 = x0 + 0.6f;
        float y1 = y0 + 9.0f;
        float red = Color.getRedF(this.color);
        float green = Color.getGreenF(this.color);
        float blue = Color.getBlueF(this.color);
        float alpha = Color.getAlphaF(this.color);
        if (alpha == 0.0f) {
            alpha = 1.0f;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)0.0f);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        GlStateManager.func_179090_x();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)x0, (double)y1, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x1, (double)y1, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x1, (double)y0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x0, (double)y0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
    }
}

