/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.layout;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.sizer.Box;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widgets.layout.IExpander;

public class Row
extends ParentWidget<Row>
implements ILayoutWidget,
IExpander {
    private Alignment.MainAxis maa = Alignment.MainAxis.START;
    private Alignment.CrossAxis caa = Alignment.CrossAxis.START;

    public Row() {
        ((Flex)this.flex().startDefaultMode().sizeRel(1.0f, 1.0f)).endDefaultMode();
    }

    @Override
    public void layoutWidgets() {
        boolean hasWidth = this.resizer().isWidthCalculated();
        int width = this.getArea().width;
        Box padding = this.getArea().getPadding();
        Alignment.MainAxis maa = this.maa;
        if (!hasWidth && maa != Alignment.MainAxis.START) {
            if (this.flex().yAxisDependsOnChildren()) {
                maa = Alignment.MainAxis.START;
            } else {
                throw new IllegalStateException("Alignment.MainAxis other than start need the width to be calculated!");
            }
        }
        int totalWidth = 0;
        int expandedAmount = 0;
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasXPos()) continue;
            if (widget.flex().isExpanded()) {
                ++expandedAmount;
                totalWidth += widget.getArea().getMargin().horizontal();
                continue;
            }
            totalWidth += widget.getArea().requestedWidth();
        }
        if (expandedAmount > 0 && hasWidth) {
            int newWidth = (width - totalWidth - padding.horizontal()) / expandedAmount;
            for (IWidget widget : this.getChildren()) {
                if (widget.flex().hasXPos() || !widget.flex().isExpanded()) continue;
                widget.getArea().width = newWidth;
                widget.resizer().setWidthResized(true);
            }
            if (maa == Alignment.MainAxis.SPACE_BETWEEN || maa == Alignment.MainAxis.SPACE_AROUND) {
                maa = Alignment.MainAxis.START;
            }
        }
        int lastX = padding.left;
        if (hasWidth) {
            if (maa == Alignment.MainAxis.CENTER) {
                lastX = (int)((float)width / 2.0f - (float)totalWidth / 2.0f);
            } else if (maa == Alignment.MainAxis.END) {
                lastX = width - totalWidth;
            }
        }
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasXPos()) continue;
            Box margin = widget.getArea().getMargin();
            widget.getArea().rx = lastX + margin.left;
            widget.resizer().setXResized(true);
            widget.resizer().setXMarginPaddingApplied(true);
            lastX += widget.getArea().requestedWidth();
            if (!hasWidth || maa != Alignment.MainAxis.SPACE_BETWEEN) continue;
            lastX += (width - totalWidth) / (this.getChildren().size() - 1);
        }
    }

    @Override
    public void postLayoutWidgets() {
        int height = this.getArea().height;
        Box padding = this.getArea().getPadding();
        boolean hasHeight = this.resizer().isWidthCalculated();
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasXPos()) continue;
            Box margin = widget.getArea().getMargin();
            if (widget.flex().hasYPos()) continue;
            int y = margin.top + padding.top;
            if (hasHeight) {
                if (this.caa == Alignment.CrossAxis.CENTER) {
                    y = (int)((float)height / 2.0f - (float)widget.getArea().height / 2.0f);
                } else if (this.caa == Alignment.CrossAxis.END) {
                    y = height - widget.getArea().height - margin.bottom - padding.bottom;
                }
            }
            widget.getArea().ry = y;
            widget.resizer().setYResized(true);
            widget.resizer().setYMarginPaddingApplied(true);
        }
    }

    public Row crossAxisAlignment(Alignment.CrossAxis caa) {
        this.caa = caa;
        return this;
    }

    public Row mainAxisAlignment(Alignment.MainAxis maa) {
        this.maa = maa;
        return this;
    }

    @Override
    public GuiAxis getExpandAxis() {
        return GuiAxis.X;
    }
}

