/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.widget.IVanillaSlot;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.core.mixin.GuiContainerAccessor;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.TextRenderer;
import com.cleanroommc.modularui.integration.jei.JeiGhostIngredientSlot;
import com.cleanroommc.modularui.integration.jei.JeiIngredientProvider;
import com.cleanroommc.modularui.screen.GuiScreenWrapper;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.Tooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetSlotTheme;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.utils.NumberFormat;
import com.cleanroommc.modularui.value.sync.ItemSlotSH;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSlot
extends Widget<ItemSlot>
implements IVanillaSlot,
Interactable,
JeiGhostIngredientSlot<ItemStack>,
JeiIngredientProvider {
    public static final int SIZE = 18;
    private static final TextRenderer textRenderer = new TextRenderer();
    private ItemSlotSH syncHandler;

    public ItemSlot() {
        this.tooltip().setAutoUpdate(true).setHasTitleMargin(true);
        this.tooltipBuilder(tooltip -> {
            tooltip.excludeArea(this.getArea());
            if (!this.isSynced()) {
                return;
            }
            ItemStack stack = this.getSlot().func_75211_c();
            if (stack.func_190926_b()) {
                return;
            }
            tooltip.addStringLines(this.getItemTooltip(stack));
        });
    }

    @Override
    public void onInit() {
        this.size(18, 18);
        this.getContext().getJeiSettings().addJeiGhostIngredientSlot(this);
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        if (syncHandler instanceof ItemSlotSH) {
            ItemSlotSH itemSlotSH;
            this.syncHandler = itemSlotSH = (ItemSlotSH)syncHandler;
            return true;
        }
        return false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        boolean shouldBeEnabled = this.areAncestorsEnabled();
        if (shouldBeEnabled != this.getSlot().func_111238_b()) {
            this.syncHandler.setEnabled(shouldBeEnabled, true);
        }
    }

    @Override
    public void draw(GuiContext context, WidgetTheme widgetTheme) {
        if (this.syncHandler == null) {
            return;
        }
        RenderHelper.func_74520_c();
        this.drawSlot((Slot)this.getSlot());
        RenderHelper.func_74519_b();
        GlStateManager.func_179140_f();
        if (this.isHovering()) {
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiDraw.drawRect(1.0f, 1.0f, 16.0f, 16.0f, this.getWidgetTheme(context.getTheme()).getSlotHoverColor());
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @Override
    public void drawForeground(GuiContext context) {
        Tooltip tooltip = this.getTooltip();
        if (tooltip != null && this.isHoveringFor(tooltip.getShowUpTimer())) {
            tooltip.draw(this.getContext(), this.getSlot().func_75211_c());
        }
    }

    @Override
    public WidgetSlotTheme getWidgetTheme(ITheme theme) {
        return theme.getItemSlotTheme();
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        if (this.syncHandler.isPhantom()) {
            MouseData mouseData = MouseData.create(mouseButton);
            this.syncHandler.syncToServer(2, mouseData::writeToPacket);
        } else {
            this.getScreen().getScreenWrapper().clickSlot();
        }
        return Interactable.Result.SUCCESS;
    }

    @Override
    public boolean onMouseRelease(int mouseButton) {
        if (!this.syncHandler.isPhantom()) {
            this.getScreen().getScreenWrapper().releaseSlot();
        }
        return true;
    }

    @Override
    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        if (this.syncHandler.isPhantom()) {
            MouseData mouseData = MouseData.create(scrollDirection.modifier);
            this.syncHandler.syncToServer(3, mouseData::writeToPacket);
            return true;
        }
        return false;
    }

    @Override
    public void onMouseDrag(int mouseButton, long timeSinceClick) {
        this.getScreen().getScreenWrapper().dragSlot(timeSinceClick);
    }

    public ModularSlot getSlot() {
        return this.syncHandler.getSlot();
    }

    @Override
    public Slot getVanillaSlot() {
        return this.syncHandler.getSlot();
    }

    @Override
    @NotNull
    public ItemSlotSH getSyncHandler() {
        if (this.syncHandler == null) {
            throw new IllegalStateException("Widget is not initialised!");
        }
        return this.syncHandler;
    }

    protected List<String> getItemTooltip(ItemStack stack) {
        return this.getScreen().getScreenWrapper().func_191927_a(stack);
    }

    public ItemSlot slot(ModularSlot slot) {
        this.syncHandler = new ItemSlotSH(slot);
        this.setSyncHandler(this.syncHandler);
        return this;
    }

    public ItemSlot slot(IItemHandlerModifiable itemHandler, int index) {
        return this.slot(new ModularSlot((IItemHandler)itemHandler, index));
    }

    @SideOnly(value=Side.CLIENT)
    private void drawSlot(Slot slotIn) {
        GuiScreenWrapper guiScreen = this.getScreen().getScreenWrapper();
        GuiContainerAccessor accessor = guiScreen.getAccessor();
        ItemStack itemstack = slotIn.func_75211_c();
        boolean flag = false;
        boolean flag1 = slotIn == accessor.getClickedSlot() && !accessor.getDraggedStack().func_190926_b() && !accessor.getIsRightMouseClick();
        ItemStack itemstack1 = guiScreen.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        int amount = -1;
        String format = null;
        if (slotIn == accessor.getClickedSlot() && !accessor.getDraggedStack().func_190926_b() && accessor.getIsRightMouseClick() && !itemstack.func_190926_b()) {
            itemstack = itemstack.func_77946_l();
            itemstack.func_190920_e(itemstack.func_190916_E() / 2);
        } else if (guiScreen.isDragSplitting() && guiScreen.getDragSlots().contains(slotIn) && !itemstack1.func_190926_b()) {
            if (guiScreen.getDragSlots().size() == 1) {
                return;
            }
            if (Container.func_94527_a((Slot)slotIn, (ItemStack)itemstack1, (boolean)true) && guiScreen.field_147002_h.func_94531_b(slotIn)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a(guiScreen.getDragSlots(), (int)accessor.getDragSplittingLimit(), (ItemStack)itemstack, (int)(slotIn.func_75211_c().func_190926_b() ? 0 : slotIn.func_75211_c().func_190916_E()));
                int k = Math.min(itemstack.func_77976_d(), slotIn.func_178170_b(itemstack));
                if (itemstack.func_190916_E() > k) {
                    amount = k;
                    format = TextFormatting.YELLOW.toString();
                    itemstack.func_190920_e(k);
                }
            } else {
                guiScreen.getDragSlots().remove(slotIn);
                accessor.invokeUpdateDragSplitting();
            }
        }
        guiScreen.setZ(100.0f);
        guiScreen.getItemRenderer().field_77023_b = 100.0f;
        if (!flag1) {
            if (flag) {
                GuiDraw.drawRect(1.0f, 1.0f, 16.0f, 16.0f, -2130706433);
            }
            if (!itemstack.func_190926_b()) {
                GlStateManager.func_179126_j();
                guiScreen.getItemRenderer().func_184391_a((EntityLivingBase)guiScreen.field_146297_k.field_71439_g, itemstack, 1, 1);
                if (amount < 0) {
                    amount = itemstack.func_190916_E();
                }
                if (amount > 1 || format != null) {
                    String amountText = NumberFormat.formatWithMaxDigits(amount);
                    if (format != null) {
                        amountText = format + amountText;
                    }
                    float scale = 1.0f;
                    if (amountText.length() == 3) {
                        scale = 0.8f;
                    } else if (amountText.length() == 4) {
                        scale = 0.6f;
                    } else if (amountText.length() > 4) {
                        scale = 0.5f;
                    }
                    textRenderer.setShadow(true);
                    textRenderer.setScale(scale);
                    textRenderer.setColor(Color.WHITE.main);
                    textRenderer.setAlignment(Alignment.BottomRight, this.getArea().width - 1, this.getArea().height - 1);
                    textRenderer.setPos(1, 1);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179097_i();
                    GlStateManager.func_179084_k();
                    textRenderer.draw(amountText);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179147_l();
                }
                int cachedCount = itemstack.func_190916_E();
                itemstack.func_190920_e(1);
                guiScreen.getItemRenderer().func_180453_a(guiScreen.getFontRenderer(), itemstack, 1, 1, null);
                itemstack.func_190920_e(cachedCount);
                GlStateManager.func_179097_i();
            }
        }
        guiScreen.getItemRenderer().field_77023_b = 0.0f;
        guiScreen.setZ(0.0f);
    }

    @Override
    public void setGhostIngredient(@NotNull ItemStack ingredient) {
        if (this.syncHandler.isPhantom()) {
            this.syncHandler.updateFromClient(ingredient);
        }
    }

    @Override
    @Nullable
    public ItemStack castGhostIngredientIfValid(@NotNull Object ingredient) {
        ItemStack itemStack;
        return this.syncHandler.isPhantom() && ingredient instanceof ItemStack ? (itemStack = (ItemStack)ingredient) : null;
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.syncHandler.getSlot().func_75211_c();
    }
}

