/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.TextRenderer;
import com.cleanroommc.modularui.integration.jei.JeiGhostIngredientSlot;
import com.cleanroommc.modularui.integration.jei.JeiIngredientProvider;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.Tooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetSlotTheme;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.utils.NumberFormat;
import com.cleanroommc.modularui.value.sync.FluidSlotSyncHandler;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.sizer.Flex;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidSlot
extends Widget<FluidSlot>
implements Interactable,
JeiGhostIngredientSlot<FluidStack>,
JeiIngredientProvider {
    public static final int DEFAULT_SIZE = 18;
    private static final String UNIT_BUCKET = "B";
    private static final String UNIT_LITER = "L";
    private static final IFluidTank EMPTY = new FluidTank(0);
    private final TextRenderer textRenderer = new TextRenderer();
    private FluidSlotSyncHandler syncHandler;
    private int contentOffsetX = 1;
    private int contentOffsetY = 1;
    private boolean alwaysShowFull = true;
    @Nullable
    private IDrawable overlayTexture = null;

    public FluidSlot() {
        ((Flex)this.flex().startDefaultMode().size(18, 18)).endDefaultMode();
        this.tooltip().setAutoUpdate(true).setHasTitleMargin(true);
        this.tooltipBuilder(tooltip -> {
            IFluidTank fluidTank = this.getFluidTank();
            FluidStack fluid = this.syncHandler.getValue();
            if (this.syncHandler.isPhantom()) {
                if (fluid != null) {
                    tooltip.addLine(IKey.str(fluid.getLocalizedName()));
                    if (this.syncHandler.controlsAmount()) {
                        tooltip.addLine(IKey.lang("modularui.fluid.phantom.amount", this.formatFluidAmount(fluid.amount), this.getBaseUnit()));
                    }
                } else {
                    tooltip.addLine(IKey.lang("modularui.fluid.empty"));
                }
                if (this.syncHandler.controlsAmount()) {
                    tooltip.addLine(IKey.lang("modularui.fluid.phantom.control"));
                }
            } else {
                if (fluid != null) {
                    tooltip.addLine(IKey.str(fluid.getLocalizedName()));
                    tooltip.addLine(IKey.lang("modularui.fluid.amount", this.formatFluidAmount(fluid.amount), this.formatFluidAmount(fluidTank.getCapacity()), this.getBaseUnit()));
                    this.addAdditionalFluidInfo((Tooltip)tooltip, fluid);
                } else {
                    tooltip.addLine(IKey.lang("modularui.fluid.empty"));
                }
                if (this.syncHandler.canFillSlot() || this.syncHandler.canDrainSlot()) {
                    tooltip.addLine(IKey.EMPTY);
                    if (Interactable.hasShiftDown()) {
                        if (this.syncHandler.canFillSlot() && this.syncHandler.canDrainSlot()) {
                            tooltip.addLine(IKey.lang("modularui.fluid.click_combined"));
                        } else if (this.syncHandler.canDrainSlot()) {
                            tooltip.addLine(IKey.lang("modularui.fluid.click_to_fill"));
                        } else if (this.syncHandler.canFillSlot()) {
                            tooltip.addLine(IKey.lang("modularui.fluid.click_to_empty"));
                        }
                    } else {
                        tooltip.addLine(IKey.lang("modularui.tooltip.shift"));
                    }
                }
            }
        });
    }

    public void addAdditionalFluidInfo(Tooltip tooltip, FluidStack fluidStack) {
    }

    public String formatFluidAmount(double amount) {
        NumberFormat.FORMAT.setMaximumFractionDigits(3);
        return NumberFormat.FORMAT.format(this.getBaseUnitAmount(amount));
    }

    protected double getBaseUnitAmount(double amount) {
        return amount / 1000.0;
    }

    protected String getBaseUnit() {
        return UNIT_BUCKET;
    }

    @Override
    public void onInit() {
        this.textRenderer.setShadow(true);
        this.textRenderer.setScale(0.5f);
        this.textRenderer.setColor(Color.WHITE.main);
        this.getContext().getJeiSettings().addJeiGhostIngredientSlot(this);
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        if (syncHandler instanceof FluidSlotSyncHandler) {
            FluidSlotSyncHandler fluidSlotSyncHandler;
            this.syncHandler = fluidSlotSyncHandler = (FluidSlotSyncHandler)syncHandler;
            return true;
        }
        return false;
    }

    @Override
    public void draw(GuiContext context, WidgetTheme widgetTheme) {
        IFluidTank fluidTank = this.getFluidTank();
        FluidStack content = this.syncHandler.getValue();
        if (content != null) {
            int y = this.contentOffsetY;
            float height = this.getArea().height - y * 2;
            if (!this.alwaysShowFull) {
                float newHeight = height * (float)content.amount * 1.0f / (float)fluidTank.getCapacity();
                y += (int)(height - newHeight);
                height = newHeight;
            }
            GuiDraw.drawFluidTexture(content, this.contentOffsetX, y, this.getArea().width - this.contentOffsetX * 2, height, 0.0f);
        }
        if (this.overlayTexture != null) {
            this.overlayTexture.drawAtZero(context, this.getArea(), widgetTheme);
        }
        if (content != null && this.syncHandler.controlsAmount()) {
            String s = NumberFormat.formatWithMaxDigits(this.getBaseUnitAmount(content.amount)) + this.getBaseUnit();
            this.textRenderer.setAlignment(Alignment.CenterRight, (float)(this.getArea().width - this.contentOffsetX) - 1.0f);
            this.textRenderer.setPos((int)((float)this.contentOffsetX + 0.5f), (int)((float)this.getArea().height - 5.5f));
            this.textRenderer.draw(s);
        }
        if (this.isHovering()) {
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiDraw.drawRect(1.0f, 1.0f, this.getArea().w() - 2, this.getArea().h() - 2, this.getWidgetTheme(context.getTheme()).getSlotHoverColor());
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @Override
    public WidgetSlotTheme getWidgetTheme(ITheme theme) {
        return theme.getFluidSlotTheme();
    }

    @Override
    @NotNull
    public Interactable.Result onMouseTapped(int mouseButton) {
        if (!this.syncHandler.canFillSlot() && !this.syncHandler.canDrainSlot()) {
            return Interactable.Result.IGNORE;
        }
        ItemStack cursorStack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        if (this.syncHandler.isPhantom() || !cursorStack.func_190926_b() && cursorStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            MouseData mouseData = MouseData.create(mouseButton);
            this.syncHandler.syncToServer(1, mouseData::writeToPacket);
        }
        return Interactable.Result.SUCCESS;
    }

    @Override
    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        if (this.syncHandler.isPhantom()) {
            if (scrollDirection.isUp() && !this.syncHandler.canFillSlot() || scrollDirection.isDown() && !this.syncHandler.canDrainSlot()) {
                return false;
            }
            MouseData mouseData = MouseData.create(scrollDirection.modifier);
            this.syncHandler.syncToServer(2, mouseData::writeToPacket);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Interactable.Result onKeyPressed(char typedChar, int keyCode) {
        if (keyCode == 42 || keyCode == 54) {
            this.markTooltipDirty();
        }
        return Interactable.super.onKeyPressed(typedChar, keyCode);
    }

    @Override
    public boolean onKeyRelease(char typedChar, int keyCode) {
        if (keyCode == 42 || keyCode == 54) {
            this.markTooltipDirty();
        }
        return Interactable.super.onKeyRelease(typedChar, keyCode);
    }

    @Nullable
    public FluidStack getFluidStack() {
        return this.syncHandler == null ? null : this.syncHandler.getValue();
    }

    public IFluidTank getFluidTank() {
        return this.syncHandler == null ? EMPTY : this.syncHandler.getFluidTank();
    }

    public FluidSlot contentOffset(int x, int y) {
        this.contentOffsetX = x;
        this.contentOffsetY = y;
        return this;
    }

    public FluidSlot alwaysShowFull(boolean alwaysShowFull) {
        this.alwaysShowFull = alwaysShowFull;
        return this;
    }

    public FluidSlot overlayTexture(@Nullable IDrawable overlayTexture) {
        this.overlayTexture = overlayTexture;
        return this;
    }

    public FluidSlot syncHandler(IFluidTank fluidTank) {
        return this.syncHandler(new FluidSlotSyncHandler(fluidTank));
    }

    public FluidSlot syncHandler(FluidSlotSyncHandler syncHandler) {
        this.setSyncHandler(syncHandler);
        this.syncHandler = syncHandler;
        return this;
    }

    @Override
    public void setGhostIngredient(@NotNull FluidStack ingredient) {
        if (this.syncHandler.isPhantom()) {
            this.syncHandler.setValue(ingredient);
        }
    }

    @Override
    @Nullable
    public FluidStack castGhostIngredientIfValid(@NotNull Object ingredient) {
        FluidStack fluidStack;
        return this.syncHandler.isPhantom() && ingredient instanceof FluidStack ? (fluidStack = (FluidStack)ingredient) : null;
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.getFluidStack();
    }
}

