/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.layout.IResizeable;
import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.api.widget.ISynced;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.ObjectList;
import com.cleanroommc.modularui.value.sync.GuiSyncManager;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widgets.layout.IExpander;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.client.renderer.GlStateManager;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;

public class WidgetTree {
    private WidgetTree() {
    }

    public static List<IWidget> getAllChildrenByLayer(IWidget parent) {
        return WidgetTree.getAllChildrenByLayer(parent, false);
    }

    public static List<IWidget> getAllChildrenByLayer(IWidget parent, boolean includeSelf) {
        ArrayList<IWidget> children = new ArrayList<IWidget>();
        if (includeSelf) {
            children.add(parent);
        }
        ObjectList.ObjectArrayList parents = ObjectList.create();
        parents.add(parent);
        while (!parents.isEmpty()) {
            for (IWidget child : ((IWidget)parents.removeFirst()).getChildren()) {
                if (!child.getChildren().isEmpty()) {
                    parents.add(child);
                }
                children.add(child);
            }
        }
        return children;
    }

    public static boolean foreachChildBFS(IWidget parent, Predicate<IWidget> consumer) {
        return WidgetTree.foreachChildBFS(parent, consumer, false);
    }

    public static boolean foreachChildBFS(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (includeSelf && !consumer.test(parent)) {
            return false;
        }
        ObjectList.ObjectArrayList parents = ObjectList.create();
        parents.add(parent);
        while (!parents.isEmpty()) {
            for (IWidget child : ((IWidget)parents.removeFirst()).getChildren()) {
                if (child.hasChildren()) {
                    parents.addLast(child);
                }
                if (consumer.test(child)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean foreachChildByLayer2(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (includeSelf && !consumer.test(parent)) {
            return false;
        }
        ObjectList.ObjectArrayList parents = ObjectList.create();
        parents.add(parent);
        while (!parents.isEmpty()) {
            for (IWidget child : ((IWidget)parents.removeFirst()).getChildren()) {
                if (!consumer.test(child)) {
                    return false;
                }
                if (!child.hasChildren()) continue;
                parents.addLast(child);
            }
        }
        return true;
    }

    public static boolean foreachChild(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (includeSelf && !consumer.test(parent)) {
            return false;
        }
        if (parent.getChildren().isEmpty()) {
            return true;
        }
        for (IWidget widget : parent.getChildren()) {
            if (!consumer.test(widget)) {
                return false;
            }
            if (widget.getChildren().isEmpty() || !WidgetTree.foreachChild(widget, consumer, false)) continue;
            return false;
        }
        return true;
    }

    public static boolean foreachChildReverse(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (parent.getChildren().isEmpty()) {
            return !includeSelf || consumer.test(parent);
        }
        for (IWidget widget : parent.getChildren()) {
            if (!widget.getChildren().isEmpty() && WidgetTree.foreachChildReverse(widget, consumer, false)) {
                return false;
            }
            if (consumer.test(widget)) continue;
            return false;
        }
        return !includeSelf || consumer.test(parent);
    }

    public static void drawTree(IWidget parent, GuiContext context) {
        WidgetTree.drawTree(parent, context, false);
    }

    public static void drawTree(IWidget parent, GuiContext context, boolean ignoreEnabled) {
        if (!parent.isEnabled() && !ignoreEnabled) {
            return;
        }
        float alpha = parent.getPanel().getAlpha();
        IViewport viewport = parent instanceof IViewport ? (IViewport)((Object)parent) : null;
        context.pushMatrix();
        parent.transform(context);
        boolean canBeSeen = parent.canBeSeen(context);
        GlStateManager.func_179094_E();
        context.applyToOpenGl();
        if (canBeSeen) {
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GlStateManager.func_179147_l();
            WidgetTheme widgetTheme = parent.getWidgetTheme(context.getTheme());
            parent.drawBackground(context, widgetTheme);
            parent.draw(context, widgetTheme);
            parent.drawOverlay(context, widgetTheme);
        }
        if (viewport != null) {
            if (canBeSeen) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GlStateManager.func_179147_l();
                viewport.preDraw(context, false);
                GlStateManager.func_179121_F();
                context.pushViewport(viewport, parent.getArea());
                viewport.transformChildren(context);
                GlStateManager.func_179094_E();
                context.applyToOpenGl();
                viewport.preDraw(context, true);
            } else {
                context.pushViewport(viewport, parent.getArea());
                viewport.transformChildren(context);
            }
        }
        GlStateManager.func_179121_F();
        List<IWidget> children = parent.getChildren();
        if (!children.isEmpty()) {
            children.forEach(widget -> WidgetTree.drawTree(widget, context, false));
        }
        if (viewport != null) {
            if (canBeSeen) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GlStateManager.func_179147_l();
                GlStateManager.func_179094_E();
                context.applyToOpenGl();
                viewport.postDraw(context, true);
                context.popViewport(viewport);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                context.applyToOpenGl();
                viewport.postDraw(context, false);
                GlStateManager.func_179121_F();
            } else {
                context.popViewport(viewport);
            }
        }
        context.popMatrix();
    }

    public static void drawTreeForeground(IWidget parent, GuiContext context) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        parent.drawForeground(context);
        List<IWidget> children = parent.getChildren();
        if (!children.isEmpty()) {
            children.forEach(widget -> WidgetTree.drawTreeForeground(widget, context));
        }
    }

    @ApiStatus.Internal
    public static void onUpdate(IWidget parent) {
        WidgetTree.foreachChildBFS(parent, widget -> {
            widget.onUpdate();
            return true;
        }, true);
    }

    public static void resize(IWidget parent) {
        if (!WidgetTree.resizeWidget(parent, true) && !WidgetTree.resizeWidget(parent, false)) {
            throw new IllegalStateException("Failed to resize widgets");
        }
        WidgetTree.applyPos(parent);
        WidgetTree.foreachChildBFS(parent, child -> {
            child.postResize();
            return true;
        }, true);
    }

    private static boolean resizeWidget(IWidget widget, boolean init) {
        GuiAxis guiAxis;
        boolean result = false;
        boolean alreadyCalculated = false;
        IResizeable resizer = widget.resizer();
        if (resizer != null) {
            if (init) {
                widget.beforeResize();
                resizer.initResizing();
            } else {
                alreadyCalculated = resizer.isFullyCalculated();
            }
            result = alreadyCalculated || resizer.resize(widget);
        } else if (!init) {
            result = true;
            alreadyCalculated = true;
        }
        if (widget instanceof IExpander) {
            IExpander expander = (IExpander)((Object)widget);
            guiAxis = expander.getExpandAxis();
        } else {
            guiAxis = null;
        }
        GuiAxis expandAxis = guiAxis;
        List anotherResize = Collections.emptyList();
        if (widget.hasChildren()) {
            anotherResize = new ArrayList();
            for (IWidget child : widget.getChildren()) {
                if (init && expandAxis != null) {
                    child.flex().checkExpanded(expandAxis);
                }
                if (WidgetTree.resizeWidget(child, init)) continue;
                anotherResize.add(child);
            }
        }
        if (!alreadyCalculated) {
            ILayoutWidget layoutWidget;
            if (widget instanceof ILayoutWidget) {
                layoutWidget = (ILayoutWidget)((Object)widget);
                layoutWidget.layoutWidgets();
            }
            if (resizer != null && !result) {
                result = resizer.postResize(widget);
            }
            if (widget instanceof ILayoutWidget) {
                layoutWidget = (ILayoutWidget)((Object)widget);
                layoutWidget.postLayoutWidgets();
            }
        }
        if (!anotherResize.isEmpty()) {
            anotherResize.removeIf(iWidget -> WidgetTree.resizeWidget(iWidget, false));
        }
        if (result && !alreadyCalculated) {
            widget.onResized();
        }
        return result && anotherResize.isEmpty();
    }

    public static void applyPos(IWidget parent) {
        WidgetTree.foreachChildBFS(parent, child -> {
            IResizeable resizer = child.resizer();
            if (resizer != null) {
                resizer.applyPos((IGuiElement)child);
            }
            return true;
        }, true);
    }

    public static IGuiElement findParent(IGuiElement parent, Predicate<IGuiElement> filter) {
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof ModularPanel)) {
            if (filter.test(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return filter.test(parent) ? parent : null;
    }

    public static IWidget findParent(IWidget parent, Predicate<IWidget> filter) {
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof ModularPanel)) {
            if (filter.test(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return filter.test(parent) ? parent : null;
    }

    public static <T extends IWidget> T findParent(IWidget parent, Class<T> type) {
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof ModularPanel)) {
            if (type.isAssignableFrom(parent.getClass())) {
                return (T)parent;
            }
            parent = parent.getParent();
        }
        return (T)(type.isAssignableFrom(parent.getClass()) ? parent : null);
    }

    public static void collectSyncValues(GuiSyncManager syncManager, ModularPanel panel) {
        AtomicInteger id = new AtomicInteger(0);
        String syncKey = "auto_sync:" + panel.getName();
        WidgetTree.foreachChildBFS(panel, widget -> {
            ISynced synced;
            if (widget instanceof ISynced && (synced = (ISynced)((Object)widget)).isSynced() && !syncManager.hasSyncHandler(synced.getSyncHandler())) {
                syncManager.syncValue(syncKey, id.getAndIncrement(), synced.getSyncHandler());
            }
            return true;
        }, true);
    }

    public static void print(IWidget parent, Predicate<IWidget> test) {
        StringBuilder builder = new StringBuilder("Widget tree of ").append(parent).append('\n');
        WidgetTree.getTree(parent.getArea(), parent, test, builder, 0);
        ModularUI.LOGGER.info(builder.toString());
    }

    private static void getTree(Area root, IWidget parent, Predicate<IWidget> test, StringBuilder builder, int indent) {
        if (indent >= 2) {
            builder.append(StringUtils.repeat((char)' ', (int)(indent - 2))).append("- ");
        }
        builder.append(parent).append(" {").append(parent.getArea().x - root.x).append(", ").append(parent.getArea().y - root.y).append(" | ").append(parent.getArea().width).append(", ").append(parent.getArea().height).append("}\n");
        if (parent.hasChildren()) {
            for (IWidget child : parent.getChildren()) {
                if (!test.test(child)) continue;
                WidgetTree.getTree(root, child, test, builder, indent + 2);
            }
        }
    }
}

