/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.GuiErrorHandler;
import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.api.widget.IVanillaSlot;
import com.cleanroommc.modularui.core.mixin.GuiContainerAccessor;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.Stencil;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import java.io.IOException;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiScreenWrapper
extends GuiContainer {
    private final ModularScreen screen;
    private boolean init = true;
    private char lastChar;
    private int fps;
    private int frameCount = 0;
    private long timer = Minecraft.func_71386_F();

    public GuiScreenWrapper(ModularContainer container, ModularScreen screen) {
        super((Container)container);
        this.screen = screen;
        this.screen.construct(this);
    }

    public void func_73866_w_() {
        GuiErrorHandler.INSTANCE.clear();
        super.func_73866_w_();
        if (this.init) {
            this.screen.onOpen();
            this.init = false;
        }
        this.screen.onResize(this.field_146294_l, this.field_146295_m);
    }

    public void updateArea(Area mainViewport) {
        this.field_147003_i = mainViewport.x;
        this.field_147009_r = mainViewport.y;
        this.field_146999_f = mainViewport.width;
        this.field_147000_g = mainViewport.height;
    }

    public GuiContainerAccessor getAccessor() {
        return (GuiContainerAccessor)((Object)this);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ++this.frameCount;
        long time = Minecraft.func_71386_F();
        if (time - this.timer >= 1000L) {
            this.fps = this.frameCount;
            this.frameCount = 0;
            this.timer += 1000L;
        }
        Stencil.reset();
        Stencil.apply(this.screen.getScreenArea(), null);
        this.func_146276_q_();
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_146976_a(partialTicks, mouseX, mouseY);
        this.screen.drawScreen(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.drawVanillaElements(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        this.getAccessor().setHoveredSlot(null);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        this.func_146979_b(mouseX, mouseY);
        this.screen.drawForeground(partialTicks);
        RenderHelper.func_74520_c();
        this.getAccessor().setHoveredSlot(null);
        IGuiElement hovered = this.screen.getContext().getHovered();
        if (hovered instanceof IVanillaSlot) {
            IVanillaSlot vanillaSlot = (IVanillaSlot)((Object)hovered);
            this.getAccessor().setHoveredSlot(vanillaSlot.getVanillaSlot());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)i, (float)j, (float)0.0f);
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawForeground((GuiContainer)this, mouseX, mouseY));
        GlStateManager.func_179121_F();
        InventoryPlayer inventoryplayer = this.field_146297_k.field_71439_g.field_71071_by;
        ItemStack itemstack = this.getAccessor().getDraggedStack().func_190926_b() ? inventoryplayer.func_70445_o() : this.getAccessor().getDraggedStack();
        GlStateManager.func_179109_b((float)i, (float)j, (float)0.0f);
        if (!itemstack.func_190926_b()) {
            int k2 = this.getAccessor().getDraggedStack().func_190926_b() ? 8 : 16;
            String s = null;
            if (!this.getAccessor().getDraggedStack().func_190926_b() && this.getAccessor().getIsRightMouseClick()) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(MathHelper.func_76123_f((float)((float)itemstack.func_190916_E() / 2.0f)));
            } else if (this.field_147007_t && this.field_147008_s.size() > 1) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(this.getAccessor().getDragSplittingRemnant());
                if (itemstack.func_190926_b()) {
                    s = TextFormatting.YELLOW + "0";
                }
            }
            this.drawItemStack(itemstack, mouseX - i - 8, mouseY - j - k2, s);
        }
        if (!this.getAccessor().getReturningStack().func_190926_b()) {
            float f = (float)(Minecraft.func_71386_F() - this.getAccessor().getReturningStackTime()) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.getAccessor().setReturningStack(ItemStack.field_190927_a);
            }
            int l2 = this.getAccessor().getReturningStackDestSlot().field_75223_e - this.getAccessor().getTouchUpX();
            int i3 = this.getAccessor().getReturningStackDestSlot().field_75221_f - this.getAccessor().getTouchUpY();
            int l1 = this.getAccessor().getTouchUpX() + (int)((float)l2 * f);
            int i2 = this.getAccessor().getTouchUpY() + (int)((float)i3 * f);
            this.drawItemStack(this.getAccessor().getReturningStack(), l1, i2, null);
        }
        GlStateManager.func_179121_F();
        if (ModularUIConfig.guiDebugMode) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            this.drawDebugScreen();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GuiErrorHandler.INSTANCE.drawErrors(0, 0);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179091_B();
        RenderHelper.func_74519_b();
        Stencil.remove();
    }

    public void func_146270_b(int tint) {
        if (ModularUI.isBlurLoaded() || this.field_146297_k.field_71441_e == null) {
            super.func_146270_b(tint);
            return;
        }
        float alpha = this.screen.getMainPanel().getAlpha();
        int color = 0x101010;
        int startAlpha = 192;
        int endAlpha = 208;
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, Color.withAlpha(color, (int)((float)startAlpha * alpha)), Color.withAlpha(color, (int)((float)endAlpha * alpha)));
    }

    private void drawItemStack(ItemStack stack, int x, int y, String altText) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        GlStateManager.func_179126_j();
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y - (this.getAccessor().getDraggedStack().func_190926_b() ? 0 : 8), altText);
        GlStateManager.func_179097_i();
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    protected void drawVanillaElements(int mouseX, int mouseY, float partialTicks) {
        for (GuiButton guiButton : this.field_146292_n) {
            guiButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
        for (GuiLabel guiLabel : this.field_146293_o) {
            guiLabel.func_146159_a(this.field_146297_k, mouseX, mouseY);
        }
    }

    public void drawDebugScreen() {
        GuiContext context = this.screen.getContext();
        int mouseX = context.getAbsMouseX();
        int mouseY = context.getAbsMouseY();
        int screenH = this.screen.getScreenArea().height;
        int color = Color.rgb(180, 40, 115);
        int lineY = screenH - 13;
        this.func_73731_b(this.field_146289_q, "Mouse Pos: " + mouseX + ", " + mouseY, 5, lineY, color);
        lineY -= 11;
        this.func_73731_b(this.field_146289_q, "FPS: " + this.fps, 5, screenH - 24, color);
        LocatedWidget locatedHovered = this.screen.getPanelManager().getTopWidgetLocated(true);
        if (locatedHovered != null) {
            this.drawSegmentLine(lineY -= 4, color);
            lineY -= 10;
            IGuiElement hovered = (IGuiElement)locatedHovered.getElement();
            locatedHovered.applyMatrix(context);
            GlStateManager.func_179094_E();
            context.applyToOpenGl();
            Area area = hovered.getArea();
            IGuiElement parent = hovered.getParent();
            GuiDraw.drawBorder(0.0f, 0.0f, area.width, area.height, color, 1.0f);
            if (hovered.hasParent()) {
                GuiDraw.drawBorder(-area.rx, -area.ry, parent.getArea().width, parent.getArea().height, Color.withAlpha(color, 0.3f), 1.0f);
            }
            GlStateManager.func_179121_F();
            locatedHovered.unapplyMatrix(context);
            GuiDraw.drawText("Pos: " + area.x + ", " + area.y + "  Rel: " + area.rx + ", " + area.ry, 5.0f, lineY, 1.0f, color, false);
            GuiDraw.drawText("Size: " + area.width + ", " + area.height, 5.0f, lineY -= 11, 1.0f, color, false);
            GuiDraw.drawText("Class: " + hovered, 5.0f, lineY -= 11, 1.0f, color, false);
            if (hovered.hasParent()) {
                this.drawSegmentLine(lineY -= 4, color);
                area = parent.getArea();
                GuiDraw.drawText("Parent size: " + area.width + ", " + area.height, 5.0f, lineY -= 10, 1.0f, color, false);
                GuiDraw.drawText("Parent: " + parent, 5.0f, lineY -= 11, 1.0f, color, false);
            }
            if (hovered instanceof ItemSlot) {
                ItemSlot slotWidget = (ItemSlot)hovered;
                this.drawSegmentLine(lineY -= 4, color);
                ModularSlot slot = slotWidget.getSlot();
                GuiDraw.drawText("Slot Index: " + slot.getSlotIndex(), 5.0f, lineY -= 10, 1.0f, color, false);
                GuiDraw.drawText("Slot Number: " + slot.field_75222_d, 5.0f, lineY -= 11, 1.0f, color, false);
                lineY -= 11;
                if (slotWidget.isSynced()) {
                    SlotGroup slotGroup = slot.getSlotGroup();
                    boolean allowShiftTransfer = slotGroup != null && slotGroup.allowShiftTransfer();
                    GuiDraw.drawText("Shift-Click Priority: " + (allowShiftTransfer ? Integer.valueOf(slotGroup.getShiftClickPriority()) : "DISABLED"), 5.0f, lineY, 1.0f, color, false);
                }
            }
        }
        GuiScreenWrapper.func_73734_a((int)mouseX, (int)mouseY, (int)(mouseX + 1), (int)(mouseY + 1), (int)Color.withAlpha(Color.GREEN.main, 0.8f));
    }

    private void drawSegmentLine(int y, int color) {
        GuiDraw.drawRect(5.0f, y, 140.0f, 1.0f, color);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.screen.onUpdate();
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.screen.onClose();
        this.init = true;
    }

    public ModularScreen getScreen() {
        return this.screen;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.screen.onMousePressed(mouseButton)) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void clickSlot() {
        try {
            super.func_73864_a(this.screen.getContext().getAbsMouseX(), this.screen.getContext().getAbsMouseY(), this.screen.getContext().getMouseButton());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.screen.onMouseRelease(state)) {
            return;
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    public void releaseSlot() {
        super.func_146286_b(this.screen.getContext().getAbsMouseX(), this.screen.getContext().getAbsMouseY(), this.screen.getContext().getMouseButton());
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.screen.onMouseDrag(clickedMouseButton, timeSinceLastClick)) {
            return;
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    public void dragSlot(long timeSinceLastClick) {
        super.func_146273_a(this.screen.getContext().getAbsMouseX(), this.screen.getContext().getAbsMouseY(), this.screen.getContext().getMouseButton(), timeSinceLastClick);
    }

    public void func_146282_l() {
        char c0 = Keyboard.getEventCharacter();
        int key = Keyboard.getEventKey();
        boolean state = Keyboard.getEventKeyState();
        if (state) {
            this.lastChar = c0;
            if (this.screen.onKeyPressed(c0, key)) {
                return;
            }
            this.func_73869_a(c0, key);
        } else {
            if (this.screen.onKeyRelease(this.lastChar, key)) {
                return;
            }
            if (key == 0 && c0 >= ' ') {
                this.func_73869_a(c0, key);
            }
        }
        this.field_146297_k.func_152348_aa();
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 46 && GuiScreenWrapper.func_146271_m() && GuiScreenWrapper.func_146272_n() && GuiScreenWrapper.func_175283_s()) {
            ModularUIConfig.guiDebugMode = !ModularUIConfig.guiDebugMode;
            return;
        }
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            if (this.screen.getContext().hasDraggable()) {
                this.screen.getContext().dropDraggable();
            } else {
                this.screen.getPanelManager().closeTopPanel(true);
            }
        }
        this.func_146983_a(keyCode);
        Slot hoveredSlot = this.getAccessor().getHoveredSlot();
        if (hoveredSlot != null && hoveredSlot.func_75216_d()) {
            if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(keyCode)) {
                this.func_184098_a(hoveredSlot, hoveredSlot.field_75222_d, 0, ClickType.CLONE);
            } else if (this.field_146297_k.field_71474_y.field_74316_C.isActiveAndMatches(keyCode)) {
                this.func_184098_a(hoveredSlot, hoveredSlot.field_75222_d, GuiScreenWrapper.func_146271_m() ? 1 : 0, ClickType.THROW);
            }
        }
    }

    public boolean isDragSplitting() {
        return this.field_147007_t;
    }

    public Set<Slot> getDragSlots() {
        return this.field_147008_s;
    }

    public RenderItem getItemRenderer() {
        return this.field_146296_j;
    }

    public float getZ() {
        return this.field_73735_i;
    }

    public void setZ(float z) {
        this.field_73735_i = z;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }
}

