/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.widget;

import com.cleanroommc.modularui.api.layout.IResizeable;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.widget.sizer.Area;

public interface IGuiElement {
    public ModularScreen getScreen();

    public IGuiElement getParent();

    public boolean hasParent();

    public IResizeable resizer();

    public Area getArea();

    default public Area getParentArea() {
        return this.getParent().getArea();
    }

    public void draw(GuiContext var1);

    default public void onMouseStartHover() {
    }

    default public void onMouseEndHover() {
    }

    default public boolean isHovering() {
        return this.getScreen().getContext().isHovered(this);
    }

    default public boolean isHoveringFor(int ticks) {
        return this.getScreen().getContext().isHoveredFor(this, ticks);
    }

    default public boolean isBelowMouse() {
        IGuiElement hovered = this.getScreen().getContext().getHovered();
        if (hovered == null) {
            return false;
        }
        while (!(hovered instanceof ModularPanel)) {
            if (hovered == this) {
                return true;
            }
            hovered = hovered.getParent();
        }
        return hovered == this;
    }

    public boolean isEnabled();

    default public int getDefaultWidth() {
        return 18;
    }

    default public int getDefaultHeight() {
        return 18;
    }
}

