/*
 * Decompiled with CFR 0.152.
 */
package surreal.fixeroo.core;

import net.minecraft.launchwrapper.IClassTransformer;
import surreal.fixeroo.core.FixerooPlugin;
import surreal.fixeroo.core.transformers.ElytraTransformer;
import surreal.fixeroo.core.transformers.GolemTransformer;
import surreal.fixeroo.core.transformers.MPSTransformer;
import surreal.fixeroo.core.transformers.PreciseEntityPositionTransformer;
import surreal.fixeroo.core.transformers.ShulkerColoringTransformer;
import surreal.fixeroo.core.transformers.TESRRenderDistanceTransformer;
import surreal.fixeroo.core.transformers.XPOrbTransformer;

public class FixerooTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!FixerooPlugin.configAnytime) {
            return basicClass;
        }
        switch (transformedName) {
            case "net.minecraft.entity.item.EntityXPOrb": {
                return XPOrbTransformer.transformEntityXPOrb(transformedName, basicClass);
            }
            case "net.minecraft.client.renderer.entity.RenderXPOrb": {
                return XPOrbTransformer.transformRenderXPOrb(transformedName, basicClass);
            }
            case "net.minecraft.block.BlockPumpkin": {
                return GolemTransformer.transformBlockPumpkin(transformedName, basicClass);
            }
            case "net.minecraft.client.model.ModelPlayer": 
            case "net.minecraft.client.model.ModelBiped": {
                return ElytraTransformer.transformModelPlayer(transformedName, basicClass);
            }
            case "net.minecraft.client.renderer.entity.RenderPlayer": {
                return ElytraTransformer.transformRenderPlayer(transformedName, basicClass);
            }
            case "net.minecraft.entity.player.EntityPlayer": {
                return ElytraTransformer.transformEntityPlayer(transformedName, basicClass);
            }
            case "net.minecraft.client.entity.EntityPlayerSP": {
                return PreciseEntityPositionTransformer.transformEntityPlayerSP(transformedName, basicClass);
            }
            case "net.minecraft.entity.monster.EntityShulker": {
                return ShulkerColoringTransformer.transformEntityShulker(transformedName, basicClass);
            }
            case "net.darkhax.darkutils.features.shulkerpearl.FeatureShulkerPearlItem": {
                return ShulkerColoringTransformer.transformFeatureShulkerPearlItem(transformedName, basicClass);
            }
            case "net.minecraft.tileentity.TileEntity": {
                return TESRRenderDistanceTransformer.transformTileEntity(transformedName, basicClass);
            }
            case "net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher": {
                return TESRRenderDistanceTransformer.transformTileEntityRendererDispatcher(transformedName, basicClass);
            }
            case "net.machinemuse.powersuits.common.base.ModuleManager": {
                return MPSTransformer.transformModuleManager(transformedName, basicClass);
            }
            case "net.machinemuse.powersuits.common.config.MPSSettings": {
                return MPSTransformer.transformMPSSettings(transformedName, basicClass);
            }
        }
        return basicClass;
    }
}

