/*
 * Decompiled with CFR 0.152.
 */
package bqtweaker.client.gui;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.io.FloatSimpleIO;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.popups.PopContextMenu;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.SimpleTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.GuiQuest;
import betterquesting.client.gui2.editors.GuiQuestEditor;
import betterquesting.client.gui2.editors.GuiRewardEditor;
import betterquesting.client.gui2.editors.GuiTaskEditor;
import betterquesting.network.handlers.NetQuestAction;
import betterquesting.questing.QuestDatabase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector4f;

public class GuiQuestOverride
extends GuiScreenCanvas
implements IPEventListener,
INeedsRefresh {
    private static final Map<Integer, GuiQuest.ScrollPosition> scrollsPositions = new HashMap<Integer, GuiQuest.ScrollPosition>();
    private GuiQuest.ScrollPosition scrollPosition;
    private final int questID;
    private IQuest quest;
    private PanelButton btnDetect;
    private PanelButton btnClaim;
    private CanvasEmpty cvInner;
    private IGuiRect rectDescReward;
    private IGuiRect rectTask;
    private CanvasEmpty pnDescReward;
    private CanvasEmpty pnTask;
    private CanvasScrolling csDescReward;
    private CanvasScrolling csTask;

    public GuiQuestOverride(GuiScreen parent, int questID) {
        super(parent);
        this.questID = questID;
        this.scrollPosition = scrollsPositions.get(questID);
        if (this.scrollPosition == null) {
            this.scrollPosition = new GuiQuest.ScrollPosition(0, 0, 0);
            scrollsPositions.put(questID, this.scrollPosition);
        }
    }

    public void initPanel() {
        super.initPanel();
        this.quest = (IQuest)QuestDatabase.INSTANCE.getValue(this.questID);
        if (this.quest == null) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        CanvasTextured cvBackground = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel((IGuiPanel)cvBackground);
        PanelTextBox panTxt = new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate((String)((String)this.quest.getProperty(NativeProps.NAME)), (Object[])new Object[0])).setAlignment(1);
        panTxt.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel((IGuiPanel)panTxt);
        if (((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g)) {
            cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -24, 100, 16, 0), 0, QuestTranslation.translate((String)"gui.back", (Object[])new Object[0])));
            cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -24, 100, 16, 0), 1, QuestTranslation.translate((String)"betterquesting.btn.edit", (Object[])new Object[0])));
        } else {
            cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -24, 200, 16, 0), 0, QuestTranslation.translate((String)"gui.back", (Object[])new Object[0])));
        }
        this.cvInner = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(16, 32, 16, 24), 0));
        cvBackground.addPanel((IGuiPanel)this.cvInner);
        if (this.quest.getRewards().size() > 0) {
            this.btnClaim = new PanelButton((IGuiRect)new GuiTransform(new Vector4f(0.0f, 1.0f, 0.5f, 1.0f), new GuiPadding(16, -16, 24, 0), 0), 6, QuestTranslation.translate((String)"betterquesting.btn.claim", (Object[])new Object[0]));
            this.btnClaim.setActive(false);
            this.cvInner.addPanel((IGuiPanel)this.btnClaim);
        }
        this.rectDescReward = new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(0, 0, 8, 16), 0);
        this.rectDescReward.setParent(this.cvInner.getTransform());
        CanvasEmpty descRewardPopup = new CanvasEmpty(this.rectDescReward){

            public boolean onMouseClick(int mx, int my, int click) {
                if (click == 1 && GuiQuestOverride.this.rectDescReward.contains(mx, my) && ((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).canUserEdit((EntityPlayer)GuiQuestOverride.this.field_146297_k.field_71439_g)) {
                    int width = RenderUtils.getStringWidth((String)QuestTranslation.translate((String)"betterquesting.context.add_reward", (Object[])new Object[0]), (FontRenderer)Minecraft.func_71410_x().field_71466_p);
                    PopContextMenu popup = new PopContextMenu(new GuiRectangle(mx, my, width + 12, 16), true);
                    GuiRewardEditor editor = new GuiRewardEditor((GuiScreen)new GuiQuestOverride(GuiQuestOverride.this.parent, GuiQuestOverride.this.questID), GuiQuestOverride.this.quest);
                    Runnable action = () -> GuiQuestOverride.this.field_146297_k.func_147108_a((GuiScreen)editor);
                    popup.addButton(QuestTranslation.translate((String)"betterquesting.context.add_reward", (Object[])new Object[0]), null, action);
                    GuiQuestOverride.this.openPopup((IGuiPanel)popup);
                    return true;
                }
                return false;
            }
        };
        this.cvInner.addPanel((IGuiPanel)descRewardPopup);
        this.refreshRewardDescPanel();
        this.btnDetect = new PanelButton((IGuiRect)new GuiTransform(new Vector4f(0.5f, 1.0f, 1.0f, 1.0f), new GuiPadding(24, -16, 16, 0), 0), 7, QuestTranslation.translate((String)"betterquesting.btn.detect_submit", (Object[])new Object[0]));
        this.btnDetect.setActive(false);
        this.cvInner.addPanel((IGuiPanel)this.btnDetect);
        this.rectTask = new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 0, 0, 16), 0);
        this.rectTask.setParent(this.cvInner.getTransform());
        CanvasEmpty taskPopup = new CanvasEmpty(this.rectTask){

            public boolean onMouseClick(int mx, int my, int click) {
                if (click == 1) {
                    if (GuiQuestOverride.this.rectTask.getX() >= mx || GuiQuestOverride.this.rectTask.getX() + GuiQuestOverride.this.rectTask.getWidth() <= mx || GuiQuestOverride.this.rectTask.getY() >= my || GuiQuestOverride.this.rectTask.getY() + GuiQuestOverride.this.rectTask.getHeight() <= my) {
                        return false;
                    }
                    if (((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).canUserEdit((EntityPlayer)GuiQuestOverride.this.field_146297_k.field_71439_g)) {
                        int width = RenderUtils.getStringWidth((String)QuestTranslation.translate((String)"betterquesting.context.add_task", (Object[])new Object[0]), (FontRenderer)Minecraft.func_71410_x().field_71466_p);
                        PopContextMenu popup = new PopContextMenu(new GuiRectangle(mx, my, width + 12, 16), true);
                        GuiTaskEditor editor = new GuiTaskEditor((GuiScreen)new GuiQuestOverride(GuiQuestOverride.this.parent, GuiQuestOverride.this.questID), GuiQuestOverride.this.quest);
                        Runnable action = () -> GuiQuestOverride.this.field_146297_k.func_147108_a((GuiScreen)editor);
                        popup.addButton(QuestTranslation.translate((String)"betterquesting.context.add_task", (Object[])new Object[0]), null, action);
                        GuiQuestOverride.this.openPopup((IGuiPanel)popup);
                        return true;
                    }
                }
                return false;
            }
        };
        this.cvInner.addPanel((IGuiPanel)taskPopup);
        this.refreshTaskPanel();
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 0, 0, 0, 0);
        ls0.setParent(this.cvInner.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, 0, 0, 0, 0);
        le0.setParent(this.cvInner.getTransform());
        PanelLine paLine0 = new PanelLine((IGuiRect)ls0, (IGuiRect)le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        this.cvInner.addPanel((IGuiPanel)paLine0);
    }

    public void refreshGui() {
        this.refreshTaskPanel();
        this.refreshRewardDescPanel();
        this.updateButtons();
    }

    public boolean onMouseClick(int mx, int my, int click) {
        if (super.onMouseClick(mx, my, click)) {
            this.updateButtons();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onMouseRelease(int mx, int my, int click) {
        boolean var4;
        try {
            var4 = super.onMouseRelease(mx, my, click);
        }
        finally {
            if (this.csDescReward != null) {
                this.scrollPosition.setDescScrollY(this.csDescReward.getScrollY());
            }
            if (this.csTask != null) {
                this.scrollPosition.setTaskScrollY(this.csTask.getScrollY());
            }
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onMouseScroll(int mx, int my, int scroll) {
        boolean var4;
        try {
            if (!super.onMouseScroll(mx, my, scroll)) {
                boolean bl = false;
                return bl;
            }
            this.updateButtons();
            var4 = true;
        }
        finally {
            if (this.csDescReward != null) {
                this.scrollPosition.setDescScrollY(this.csDescReward.getScrollY());
            }
            if (this.csTask != null) {
                this.scrollPosition.setTaskScrollY(this.csTask.getScrollY());
            }
        }
        return var4;
    }

    public boolean onKeyTyped(char c, int keycode) {
        if (super.onKeyTyped(c, keycode)) {
            this.updateButtons();
            return true;
        }
        return false;
    }

    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestEditor((GuiScreen)this, this.questID));
        } else if (btn.getButtonID() == 6) {
            NetQuestAction.requestClaim((int[])new int[]{this.questID});
        } else if (btn.getButtonID() == 7) {
            NetQuestAction.requestDetect((int[])new int[]{this.questID});
        }
    }

    private void refreshRewardDescPanel() {
        if (this.pnDescReward != null) {
            this.cvInner.removePanel((IGuiPanel)this.pnDescReward);
        }
        this.pnDescReward = new CanvasEmpty(this.rectDescReward);
        this.cvInner.addPanel((IGuiPanel)this.pnDescReward);
        this.csDescReward = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 8, 1), 0));
        this.pnDescReward.addPanel((IGuiPanel)this.csDescReward);
        PanelVScrollBar paDescScroll = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 0, 0, 0), 0));
        this.pnDescReward.addPanel((IGuiPanel)paDescScroll);
        this.csDescReward.setScrollDriverY((IValueIO)paDescScroll);
        String desc = QuestTranslation.translate((String)((String)this.quest.getProperty(NativeProps.DESC)), (Object[])new Object[0]);
        int yOffset = 0;
        if (desc.contains("{Embed}")) {
            String[] descSplit;
            for (String split : descSplit = desc.split("\\{Embed\\}")) {
                if (split.startsWith("TypeImage") || split.startsWith("TypeLink")) {
                    try {
                        String[] embedEntry = split.split(";");
                        int width = Math.min(this.csDescReward.getTransform().getWidth(), Integer.parseInt(embedEntry[2]));
                        int height = Integer.parseInt(embedEntry[3]);
                        if (embedEntry[0].contentEquals("TypeImage")) {
                            SimpleTexture embedImage = new SimpleTexture(new ResourceLocation(embedEntry[1]), (IGuiRect)new GuiRectangle(0, 0, Integer.parseInt(embedEntry[4]), Integer.parseInt(embedEntry[5])));
                            this.csDescReward.addCulledPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle((this.csDescReward.getTransform().getWidth() - width) / 2, yOffset, width, height), (IGuiTexture)embedImage), false);
                        } else if (embedEntry[0].contentEquals("TypeLink")) {
                            PanelButton btnLink = new PanelButton((IGuiRect)new GuiRectangle((this.csDescReward.getTransform().getWidth() - width) / 2, yOffset, width, height), 69, embedEntry[4]);
                            btnLink.setClickAction(b -> {
                                TextComponentString component = new TextComponentString(embedEntry[1]);
                                component.func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, embedEntry[1])));
                                this.func_175276_a((ITextComponent)component);
                            });
                            btnLink.setTextAlignment(1);
                            this.csDescReward.addCulledPanel((IGuiPanel)btnLink, false);
                        }
                        yOffset += height + 8;
                    }
                    catch (Exception embedEntry) {}
                    continue;
                }
                PanelTextBox paDesc = new PanelTextBox((IGuiRect)new GuiRectangle(0, yOffset, this.csDescReward.getTransform().getWidth(), 0), split, true);
                paDesc.setColor(PresetColor.TEXT_MAIN.getColor());
                this.csDescReward.addCulledPanel((IGuiPanel)paDesc, false);
                yOffset += paDesc.getTransform().getHeight() + 8;
            }
            yOffset += 16;
        } else {
            PanelTextBox paDesc = new PanelTextBox((IGuiRect)new GuiRectangle(0, yOffset, this.csDescReward.getTransform().getWidth(), 0), desc, true);
            paDesc.setColor(PresetColor.TEXT_MAIN.getColor());
            this.csDescReward.addCulledPanel((IGuiPanel)paDesc, false);
            yOffset += 16 + paDesc.getTransform().getHeight() + 8;
        }
        for (DBEntry entry : this.quest.getRewards().getEntries()) {
            IReward rew = (IReward)entry.getValue();
            PanelTextBox rwdTitle = new PanelTextBox((IGuiRect)new GuiTransform((ReadableVector4f)new Vector4f(), 0, yOffset, this.csDescReward.getTransform().getWidth(), 12, 0), QuestTranslation.translate((String)rew.getUnlocalisedName(), (Object[])new Object[0]));
            rwdTitle.setColor(PresetColor.TEXT_HEADER.getColor()).setAlignment(1);
            rwdTitle.setEnabled(true);
            this.csDescReward.addPanel((IGuiPanel)rwdTitle);
            IGuiPanel pnReward = rew.getRewardGui((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, 0, 0, this.csDescReward.getTransform().getWidth(), this.csDescReward.getTransform().getHeight(), 111), new DBEntry(this.questID, (Object)this.quest));
            pnReward.initPanel();
            CanvasEmpty tmpCanvas = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, 0, yOffset += 14, this.csDescReward.getTransform().getWidth(), pnReward.getTransform().getHeight() - pnReward.getTransform().getY(), 1));
            this.csDescReward.addPanel((IGuiPanel)tmpCanvas);
            tmpCanvas.addPanel(pnReward);
            yOffset += tmpCanvas.getTransform().getHeight() + 4;
        }
        paDescScroll.setEnabled(this.csDescReward.getScrollBounds().getHeight() > 0);
        this.csDescReward.setScrollY(this.scrollPosition.getDescScrollY());
        this.csDescReward.updatePanelScroll();
        this.updateButtons();
    }

    private void refreshTaskPanel() {
        if (this.pnTask != null) {
            this.cvInner.removePanel((IGuiPanel)this.pnTask);
        }
        this.pnTask = new CanvasEmpty(this.rectTask);
        this.cvInner.addPanel((IGuiPanel)this.pnTask);
        this.csTask = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 8, 1), 0));
        this.pnTask.addPanel((IGuiPanel)this.csTask);
        PanelVScrollBar scList = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 0, 0, 0), 0));
        this.pnTask.addPanel((IGuiPanel)scList);
        this.csTask.setScrollDriverY((IValueIO)scList);
        this.csTask.setScrollDriverX((IValueIO)new FloatSimpleIO(0.0f, 0.0f, 0.0f));
        int yOffset = 0;
        List entries = this.quest.getTasks().getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            ITask tsk = (ITask)((DBEntry)entries.get(i)).getValue();
            String taskName = i + 1 + ". " + QuestTranslation.translate((String)tsk.getUnlocalisedName(), (Object[])new Object[0]);
            PanelTextBox titleReward = new PanelTextBox((IGuiRect)new GuiTransform((ReadableVector4f)new Vector4f(), 0, yOffset, this.rectTask.getWidth(), 12, 0), taskName);
            titleReward.setColor(PresetColor.TEXT_HEADER.getColor()).setAlignment(1);
            titleReward.setEnabled(true);
            this.csTask.addPanel((IGuiPanel)titleReward);
            yOffset += 10;
            IGuiPanel taskGui = tsk.getTaskGui((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, 0, i == 0 && entries.size() == 1 && tsk.displaysCenteredAlone() ? this.rectTask.getHeight() / 3 : 0, this.rectTask.getWidth(), this.rectTask.getHeight(), 0), new DBEntry(this.questID, (Object)this.quest));
            if (taskGui != null) {
                taskGui.initPanel();
                CanvasEmpty tempCanvas = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, 0, yOffset, this.rectTask.getWidth(), taskGui.getTransform().getHeight() - taskGui.getTransform().getY(), 1));
                this.csTask.addPanel((IGuiPanel)tempCanvas);
                tempCanvas.addPanel(taskGui);
                int guiHeight = tempCanvas.getTransform().getHeight();
                yOffset += guiHeight;
            }
            yOffset += 8;
        }
        scList.setEnabled(this.csTask.getScrollBounds().getHeight() > 0);
        this.csTask.setScrollY(this.scrollPosition.getTaskScrollY());
        this.csTask.updatePanelScroll();
        this.updateButtons();
    }

    private void updateButtons() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.btnClaim != null) {
            this.btnClaim.setActive(this.quest.getRewards().size() > 0 && this.quest.canClaim((EntityPlayer)mc.field_71439_g));
        }
        if (this.btnDetect != null) {
            this.btnDetect.setActive(this.quest.canSubmit((EntityPlayer)mc.field_71439_g));
        }
    }
}

