/*
 * Decompiled with CFR 0.152.
 */
package bqtweaker.client.gui;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.enums.EnumLogic;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasHoverTray;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.popups.PopChoice;
import betterquesting.api2.client.gui.popups.PopContextMenu;
import betterquesting.api2.client.gui.resources.colors.GuiColorPulse;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.GuiTextureColored;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.OreDictTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.GuiHome;
import betterquesting.client.gui2.GuiQuest;
import betterquesting.client.gui2.GuiQuestLines;
import betterquesting.client.gui2.GuiQuestSearch;
import betterquesting.client.gui2.editors.GuiQuestEditor;
import betterquesting.client.gui2.editors.GuiQuestLinesEditor;
import betterquesting.client.gui2.editors.designer.GuiDesigner;
import betterquesting.handlers.ConfigHandler;
import betterquesting.network.handlers.NetQuestAction;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import bqtweaker.client.gui.panels.PanelTextBoxTooltip;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Tuple;

public class GuiQuestLinesOverride
extends GuiScreenCanvas
implements IPEventListener,
INeedsRefresh {
    private static int selectedLineId = -1;
    private static GuiQuestLines.ScrollPosition scrollPosition;
    private IQuestLine selectedLine = null;
    private final List<Tuple<DBEntry<IQuestLine>, Integer>> visChapters = new ArrayList<Tuple<DBEntry<IQuestLine>, Integer>>();
    private CanvasQuestLine cvQuest;
    private CanvasScrolling cvLines;
    private PanelVScrollBar scLines;
    private PanelGeneric icoChapter;
    private PanelTextBox txTitle;
    private CanvasScrolling txDescScrolling;
    private PanelVScrollBar txDescDriver;
    private PanelTextBox txDesc;
    private PanelTextBox txCompletion;
    private PanelButton claimAll;
    private PanelButton btnDesign;
    private final List<PanelButtonStorage<DBEntry<IQuestLine>>> btnListRef = new ArrayList<PanelButtonStorage<DBEntry<IQuestLine>>>();
    private static boolean viewMode;

    public GuiQuestLinesOverride(GuiScreen parent) {
        super(parent);
        viewMode = BQ_Settings.viewMode;
        if (scrollPosition == null) {
            scrollPosition = new GuiQuestLines.ScrollPosition(0);
        }
    }

    public void refreshGui() {
        this.refreshChapterVisibility();
        this.refreshContent();
    }

    public void initPanel() {
        super.initPanel();
        GuiHome.bookmark = this;
        if (!BQ_Settings.skipHome) {
            ConfigHandler.config.get("general", "Skip Home", false).set(true);
            ConfigHandler.config.save();
            BQ_Settings.skipHome = true;
        }
        if (selectedLineId >= 0) {
            this.selectedLine = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(selectedLineId);
            if (this.selectedLine == null) {
                selectedLineId = -1;
            }
        } else {
            this.selectedLine = null;
        }
        final boolean canEdit = ((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g);
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        CanvasTextured cvBackground = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel((IGuiPanel)cvBackground);
        CanvasTextured cvTopBar = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -32), 0), PresetTexture.PANEL_MAIN.getTexture());
        cvBackground.addPanel((IGuiPanel)cvTopBar);
        PanelButton btnExit = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_LEFT, 8, -24, 16, 16, 0), -1, "").setIcon(PresetIcon.ICON_PG_PREV.getTexture());
        btnExit.setClickAction(b -> this.field_146297_k.func_147108_a(this.parent));
        btnExit.setTooltip(Collections.singletonList(QuestTranslation.translate((String)"gui.back", (Object[])new Object[0])));
        cvBackground.addPanel((IGuiPanel)btnExit);
        if (bqtweaker.handlers.ConfigHandler.client.bqQuestSearching) {
            PanelButton btnSearch = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_LEFT, 8, -40, 16, 16, 0), -1, "").setIcon(PresetIcon.ICON_ZOOM.getTexture());
            btnSearch.setClickAction(this::openSearch);
            btnSearch.setTooltip(Collections.singletonList(QuestTranslation.translate((String)"betterquesting.gui.search", (Object[])new Object[0])));
            cvBackground.addPanel((IGuiPanel)btnSearch);
        }
        if (canEdit) {
            PanelButton btnEdit = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_LEFT, 8, -40 - (bqtweaker.handlers.ConfigHandler.client.bqQuestSearching ? 16 : 0), 16, 16, 0), -1, "").setIcon(PresetIcon.ICON_GEAR.getTexture());
            btnEdit.setClickAction(b -> this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestLinesEditor((GuiScreen)this)));
            btnEdit.setTooltip(Collections.singletonList(QuestTranslation.translate((String)"betterquesting.btn.edit", (Object[])new Object[0])));
            cvBackground.addPanel((IGuiPanel)btnEdit);
            this.btnDesign = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_LEFT, 8, -56 - (bqtweaker.handlers.ConfigHandler.client.bqQuestSearching ? 16 : 0), 16, 16, 0), -1, "").setIcon(PresetIcon.ICON_SORT.getTexture());
            this.btnDesign.setClickAction(b -> this.field_146297_k.func_147108_a((GuiScreen)new GuiDesigner((GuiScreen)this, this.selectedLine)));
            this.btnDesign.setTooltip(Collections.singletonList(QuestTranslation.translate((String)"betterquesting.btn.designer", (Object[])new Object[0])));
            cvBackground.addPanel((IGuiPanel)this.btnDesign);
            this.btnDesign.setActive(this.selectedLine != null);
        }
        this.icoChapter = new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, 8, 8, 16, 16, 0), null);
        cvTopBar.addPanel((IGuiPanel)this.icoChapter);
        CanvasScrolling txTitleScroll = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(26, 8, 46, 6), 0));
        cvTopBar.addPanel((IGuiPanel)txTitleScroll);
        this.txTitle = new PanelTextBoxTooltip((IGuiRect)new GuiRectangle(0, 0, txTitleScroll.getTransform().getWidth(), txTitleScroll.getTransform().getHeight()), "", true);
        this.txTitle.setColor(PresetColor.TEXT_HEADER.getColor());
        txTitleScroll.addCulledPanel((IGuiPanel)this.txTitle, false);
        CanvasScrolling txCompletionScroll = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(34 + txTitleScroll.getTransform().getWidth(), 8, 8, 6), 0));
        cvTopBar.addPanel((IGuiPanel)txCompletionScroll);
        this.txCompletion = new PanelTextBox((IGuiRect)new GuiRectangle(0, 0, txCompletionScroll.getTransform().getWidth(), txCompletionScroll.getTransform().getHeight()), "", true);
        this.txCompletion.setColor(PresetColor.TEXT_HEADER.getColor());
        txCompletionScroll.addCulledPanel((IGuiPanel)this.txCompletion, false);
        CanvasEmpty txDescEmpty = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(0, 8, 8, 6), 0));
        cvTopBar.addPanel((IGuiPanel)txDescEmpty);
        this.txDescScrolling = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 8, 0), 0));
        txDescEmpty.addPanel((IGuiPanel)this.txDescScrolling);
        this.txDescDriver = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 0, 0, 0), 0));
        this.txDescScrolling.setScrollDriverY((IValueIO)this.txDescDriver);
        txDescEmpty.addPanel((IGuiPanel)this.txDescDriver);
        this.txDesc = new PanelTextBoxTooltip((IGuiRect)new GuiRectangle(0, 0, this.txDescScrolling.getTransform().getWidth(), this.txDescScrolling.getTransform().getHeight()), "", true);
        this.txDesc.setColor(PresetColor.TEXT_HEADER.getColor());
        this.txDescScrolling.addCulledPanel((IGuiPanel)this.txDesc, false);
        this.txDescScrolling.refreshScrollBounds();
        this.txDescScrolling.updatePanelScroll();
        this.txDescDriver.setEnabled(this.txDescScrolling.getScrollBounds().getHeight() > 0);
        CanvasHoverTray cvFrame = new CanvasHoverTray((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(174, 32, 8, 8), 0), (IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(180, 32, 8, 8), 0), PresetTexture.AUX_FRAME_0.getTexture());
        cvFrame.setManualOpen(true);
        cvBackground.addPanel((IGuiPanel)cvFrame);
        cvFrame.setTrayState(true, 1L);
        CanvasEmpty cvChapterTray = new CanvasEmpty((IGuiRect)new GuiRectangle(24, 24, 164, cvFrame.getTransform().getHeight() + 16));
        cvBackground.addPanel((IGuiPanel)cvChapterTray);
        this.cvLines = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 8, 16, 8), 0));
        cvChapterTray.addPanel((IGuiPanel)this.cvLines);
        this.scLines = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-16, 8, 8, 8), 0));
        this.cvLines.setScrollDriverY((IValueIO)this.scLines);
        cvChapterTray.addPanel((IGuiPanel)this.scLines);
        PanelButton fitView = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, 8, 48, 16, 16, -2), 5, "");
        fitView.setIcon(PresetIcon.ICON_BOX_FIT.getTexture());
        fitView.setClickAction(b -> {
            if (this.cvQuest.getQuestLine() != null) {
                this.cvQuest.fitToWindow();
            }
        });
        fitView.setTooltip(Collections.singletonList(QuestTranslation.translate((String)"betterquesting.btn.zoom_fit", (Object[])new Object[0])));
        cvBackground.addPanel((IGuiPanel)fitView);
        this.claimAll = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, 8, 32, 16, 16, -2), -1, "");
        this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture());
        this.claimAll.setClickAction(b -> {
            if (BQ_Settings.claimAllConfirmation) {
                this.openPopup((IGuiPanel)new PopChoice(QuestTranslation.translate((String)"betterquesting.gui.claim_all_warning", (Object[])new Object[0]) + "\n\n" + QuestTranslation.translate((String)"betterquesting.gui.claim_all_confirm", (Object[])new Object[0]), PresetIcon.ICON_CHEST_ALL.getTexture(), integer -> {
                    if (integer == 1) {
                        ConfigHandler.config.get("general", "Claim all requires confirmation", true).set(false);
                        ConfigHandler.config.save();
                        ConfigHandler.initConfigs();
                    }
                    if (integer <= 1) {
                        this.claimAll();
                    }
                }, new String[]{QuestTranslation.translate((String)"gui.yes", (Object[])new Object[0]), QuestTranslation.translate((String)"betterquesting.gui.yes_always", (Object[])new Object[0]), QuestTranslation.translate((String)"gui.no", (Object[])new Object[0])}));
            } else {
                this.claimAll();
            }
        });
        this.claimAll.setTooltip(Collections.singletonList(QuestTranslation.translate((String)"betterquesting.btn.claim_all", (Object[])new Object[0])));
        cvBackground.addPanel((IGuiPanel)this.claimAll);
        if (bqtweaker.handlers.ConfigHandler.client.bqViewMode) {
            PanelButton btnViewMode = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, 8, 64, 16, 16, -2), -1, "").setIcon(viewMode ? PresetIcon.ICON_VISIBILITY_NORMAL.getTexture() : PresetIcon.ICON_VISIBILITY_HIDDEN.getTexture());
            btnViewMode.setClickAction(b -> {
                viewMode = !viewMode;
                b.setIcon(viewMode ? PresetIcon.ICON_VISIBILITY_NORMAL.getTexture() : PresetIcon.ICON_VISIBILITY_HIDDEN.getTexture());
                ConfigHandler.config.get("general", "View mode", false).set(viewMode);
                ConfigHandler.config.save();
                ConfigHandler.initConfigs();
                this.refreshGui();
            });
            btnViewMode.setTooltip(Collections.singletonList(QuestTranslation.translate((String)"betterquesting.btn.view_mode", (Object[])new Object[0])));
            cvBackground.addPanel((IGuiPanel)btnViewMode);
        }
        CanvasQuestLine oldCvQuest = this.cvQuest;
        this.cvQuest = new CanvasQuestLine((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), 2);
        CanvasEmpty cvQuestPopup = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0)){

            public boolean onMouseClick(int mx, int my, int click) {
                if (GuiQuestLinesOverride.this.cvQuest.getQuestLine() == null || !this.getTransform().contains(mx, my)) {
                    return false;
                }
                if (click == 1) {
                    int maxWidth;
                    boolean questExistsUnderMouse;
                    FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                    boolean bl = questExistsUnderMouse = GuiQuestLinesOverride.this.cvQuest.getButtonAt(mx, my) != null;
                    if (!canEdit && !questExistsUnderMouse) {
                        return false;
                    }
                    int n = maxWidth = questExistsUnderMouse ? RenderUtils.getStringWidth((String)QuestTranslation.translate((String)"betterquesting.btn.share_quest", (Object[])new Object[0]), (FontRenderer)fr) : 0;
                    if (canEdit) {
                        maxWidth = Math.max(maxWidth, Math.max(RenderUtils.getStringWidth((String)QuestTranslation.translate((String)"betterquesting.btn.edit", (Object[])new Object[0]), (FontRenderer)fr), RenderUtils.getStringWidth((String)QuestTranslation.translate((String)"betterquesting.btn.designer", (Object[])new Object[0]), (FontRenderer)fr)));
                    }
                    PopContextMenu popup = new PopContextMenu(new GuiRectangle(mx, my, maxWidth + 12, questExistsUnderMouse ? 48 : 16), true);
                    if (canEdit) {
                        if (questExistsUnderMouse) {
                            GuiQuestEditor editor = new GuiQuestEditor((GuiScreen)new GuiQuestLinesOverride(GuiQuestLinesOverride.this.parent), ((DBEntry)GuiQuestLinesOverride.this.cvQuest.getButtonAt(mx, my).getStoredValue()).getID());
                            Runnable actionEditor = () -> Minecraft.func_71410_x().func_147108_a((GuiScreen)editor);
                            popup.addButton(QuestTranslation.translate((String)"betterquesting.btn.edit", (Object[])new Object[0]), null, actionEditor);
                        }
                        GuiDesigner designer = new GuiDesigner((GuiScreen)new GuiQuestLinesOverride(GuiQuestLinesOverride.this.parent), GuiQuestLinesOverride.this.cvQuest.getQuestLine());
                        Runnable actionDesigner = () -> Minecraft.func_71410_x().func_147108_a((GuiScreen)designer);
                        popup.addButton(QuestTranslation.translate((String)"betterquesting.btn.designer", (Object[])new Object[0]), null, actionDesigner);
                    }
                    if (questExistsUnderMouse) {
                        Runnable questSharer = () -> {
                            GuiQuestLinesOverride.this.field_146297_k.field_71439_g.func_71165_d("betterquesting.msg.share_quest:" + ((DBEntry)GuiQuestLinesOverride.this.cvQuest.getButtonAt(mx, my).getStoredValue()).getID());
                            GuiQuestLinesOverride.this.field_146297_k.func_147108_a(null);
                        };
                        popup.addButton(QuestTranslation.translate((String)"betterquesting.btn.share_quest", (Object[])new Object[0]), null, questSharer);
                    }
                    GuiQuestLinesOverride.this.openPopup((IGuiPanel)popup);
                    return true;
                }
                return false;
            }
        };
        cvFrame.addPanel((IGuiPanel)this.cvQuest);
        cvFrame.addPanel((IGuiPanel)cvQuestPopup);
        if (this.selectedLine != null) {
            this.cvQuest.setQuestLine(this.selectedLine);
            if (oldCvQuest != null) {
                this.cvQuest.setZoom(oldCvQuest.getZoom());
                this.cvQuest.setScrollX(oldCvQuest.getScrollX());
                this.cvQuest.setScrollY(oldCvQuest.getScrollY());
                this.cvQuest.refreshScrollBounds();
                this.cvQuest.updatePanelScroll();
            }
            this.refreshQuestCompletion();
            this.txTitle.setText(QuestTranslation.translate((String)this.selectedLine.getUnlocalisedName(), (Object[])new Object[0]));
            this.txDesc.setText(QuestTranslation.translate((String)this.selectedLine.getUnlocalisedDescription(), (Object[])new Object[0]));
            this.txDescScrolling.refreshScrollBounds();
            this.txDescScrolling.updatePanelScroll();
            this.txDescDriver.setEnabled(this.txDescScrolling.getScrollBounds().getHeight() > 0);
            this.icoChapter.setTexture((IGuiTexture)new OreDictTexture(1.0f, (BigItemStack)this.selectedLine.getProperty(NativeProps.ICON), false, true), null);
        }
        this.refreshChapterVisibility();
        this.refreshClaimAll();
        this.refreshDesigner();
        this.cvLines.setScrollY(scrollPosition.getChapterScrollY());
        this.cvLines.updatePanelScroll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onMouseRelease(int mx, int my, int click) {
        boolean var4;
        try {
            var4 = super.onMouseRelease(mx, my, click);
        }
        finally {
            if (this.cvLines != null) {
                scrollPosition.setChapterScrollY(this.cvLines.getScrollY());
            }
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onMouseScroll(int mx, int my, int scroll) {
        boolean var4;
        try {
            var4 = super.onMouseScroll(mx, my, scroll);
        }
        finally {
            if (this.cvLines != null) {
                scrollPosition.setChapterScrollY(this.cvLines.getScrollY());
            }
        }
        return var4;
    }

    private void claimAll() {
        if (!this.cvQuest.getQuestButtons().isEmpty()) {
            ArrayList<Integer> claimIdList = new ArrayList<Integer>();
            for (PanelButtonQuest pbQuest : this.cvQuest.getQuestButtons()) {
                IQuest q = (IQuest)((DBEntry)pbQuest.getStoredValue()).getValue();
                if (q.getRewards().size() <= 0 || !q.canClaim((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
                claimIdList.add(((DBEntry)pbQuest.getStoredValue()).getID());
            }
            int[] cIDs = new int[claimIdList.size()];
            for (int i = 0; i < cIDs.length; ++i) {
                cIDs[i] = (Integer)claimIdList.get(i);
            }
            NetQuestAction.requestClaim((int[])cIDs);
            this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture(), (IGuiColor)new GuiColorStatic(-12303292), 0);
        }
    }

    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        Minecraft mc = Minecraft.func_71410_x();
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 2 && btn instanceof PanelButtonStorage) {
            DBEntry quest = (DBEntry)((PanelButtonStorage)btn).getStoredValue();
            GuiHome.bookmark = new GuiQuest((GuiScreen)this, quest.getID());
            mc.func_147108_a(GuiHome.bookmark);
        }
    }

    private void refreshChapterVisibility() {
        boolean canEdit = ((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g);
        List lineList = QuestLineDatabase.INSTANCE.getSortedEntries();
        this.visChapters.clear();
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g);
        for (DBEntry dbEntry : lineList) {
            int val;
            IQuestLine ql = (IQuestLine)dbEntry.getValue();
            EnumQuestVisibility vis = (EnumQuestVisibility)ql.getProperty(NativeProps.VISIBILITY);
            if (!canEdit && vis == EnumQuestVisibility.HIDDEN) continue;
            boolean show = false;
            boolean unlocked = false;
            boolean complete = false;
            boolean allComplete = true;
            boolean pendingClaim = false;
            if (canEdit) {
                show = true;
                unlocked = true;
                complete = true;
            }
            if (viewMode) {
                show = true;
            }
            for (DBEntry qID : ql.getEntries()) {
                IQuest q = (IQuest)QuestDatabase.INSTANCE.getValue(qID.getID());
                if (q == null) continue;
                if (allComplete && !this.isQuestCompletedForQuestline(playerID, q)) {
                    allComplete = false;
                }
                if (!pendingClaim && q.canClaimBasically((EntityPlayer)this.field_146297_k.field_71439_g)) {
                    pendingClaim = true;
                }
                if (!unlocked && q.isUnlocked(playerID)) {
                    unlocked = true;
                }
                if (!complete && q.isComplete(playerID)) {
                    complete = true;
                }
                if (!show && QuestCache.isQuestShown((IQuest)q, (UUID)playerID, (EntityPlayer)this.field_146297_k.field_71439_g)) {
                    show = true;
                }
                if (!unlocked || !complete || !show || !pendingClaim || allComplete) continue;
                break;
            }
            if (vis == EnumQuestVisibility.COMPLETED && !complete || vis == EnumQuestVisibility.UNLOCKED && !unlocked) continue;
            int n = val = pendingClaim ? 1 : 0;
            if (allComplete) {
                val |= 2;
            }
            if (!show) {
                val |= 4;
            }
            this.visChapters.add((Tuple<DBEntry<IQuestLine>, Integer>)new Tuple((Object)dbEntry, (Object)val));
        }
        this.buildChapterList();
    }

    private boolean isQuestCompletedForQuestline(UUID playerID, @Nonnull IQuest q) {
        if (q.isComplete(playerID)) {
            return true;
        }
        if (q.getProperty(NativeProps.VISIBILITY) == EnumQuestVisibility.HIDDEN) {
            return true;
        }
        if (q.getProperty(NativeProps.LOGIC_QUEST) == EnumLogic.XOR) {
            int reqCount = 0;
            for (int qRequirementId : q.getRequirements()) {
                IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(qRequirementId);
                if (quest.isComplete(playerID)) {
                    ++reqCount;
                }
                if (reqCount != 2) continue;
                return true;
            }
        }
        return false;
    }

    private void buildChapterList() {
        this.cvLines.resetCanvas();
        this.btnListRef.clear();
        int listW = this.cvLines.getTransform().getWidth();
        for (int n = 0; n < this.visChapters.size(); ++n) {
            DBEntry entry = (DBEntry)this.visChapters.get(n).func_76341_a();
            int vis = (Integer)this.visChapters.get(n).func_76340_b();
            this.cvLines.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(0, n * 16, 16, 16, 0), (IGuiTexture)new OreDictTexture(1.0f, (BigItemStack)((IQuestLine)entry.getValue()).getProperty(NativeProps.ICON), false, true)));
            if ((vis & 1) > 0) {
                this.cvLines.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(8, n * 16 + 8, 8, 8, -1), (IGuiTexture)new GuiTextureColored(PresetIcon.ICON_NOTICE.getTexture(), (IGuiColor)new GuiColorStatic(-256))));
            } else if ((vis & 2) > 0) {
                this.cvLines.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(8, n * 16 + 8, 8, 8, -1), (IGuiTexture)new GuiTextureColored(PresetIcon.ICON_TICK.getTexture(), (IGuiColor)new GuiColorStatic(-16711936))));
            }
            PanelButtonStorage btnLine = new PanelButtonStorage((IGuiRect)new GuiRectangle(16, n * 16, listW - 16, 16, 0), 1, QuestTranslation.translate((String)((IQuestLine)entry.getValue()).getUnlocalisedName(), (Object[])new Object[0]), (Object)entry);
            btnLine.setTextAlignment(0);
            btnLine.setActive((vis & 4) == 0 && entry.getID() != selectedLineId);
            btnLine.setCallback(q -> {
                this.btnListRef.forEach(b -> {
                    if (((DBEntry)b.getStoredValue()).getID() == selectedLineId) {
                        b.setActive(true);
                    }
                });
                btnLine.setActive(false);
                this.selectedLine = (IQuestLine)q.getValue();
                selectedLineId = q.getID();
                this.cvQuest.setQuestLine((IQuestLine)q.getValue());
                this.icoChapter.setTexture((IGuiTexture)new OreDictTexture(1.0f, (BigItemStack)((IQuestLine)q.getValue()).getProperty(NativeProps.ICON), false, true), null);
                this.refreshQuestCompletion();
                this.txTitle.setText(QuestTranslation.translate((String)((IQuestLine)q.getValue()).getUnlocalisedName(), (Object[])new Object[0]));
                this.txDesc.setText(QuestTranslation.translate((String)((IQuestLine)q.getValue()).getUnlocalisedDescription(), (Object[])new Object[0]));
                this.txDescScrolling.refreshScrollBounds();
                this.txDescScrolling.updatePanelScroll();
                this.txDescDriver.setEnabled(this.txDescScrolling.getScrollBounds().getHeight() > 0);
                this.cvQuest.fitToWindow();
                this.refreshClaimAll();
                this.refreshDesigner();
            });
            this.cvLines.addPanel((IGuiPanel)btnLine);
            this.btnListRef.add((PanelButtonStorage<DBEntry<IQuestLine>>)btnLine);
        }
        this.cvLines.refreshScrollBounds();
        this.scLines.setEnabled(this.cvLines.getScrollBounds().getHeight() > 0);
    }

    private void refreshQuestCompletion() {
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        UUID playerUUId = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.selectedLine != null) {
            int questsCompleted = 0;
            int totalQuests = 0;
            for (DBEntry entry : this.selectedLine.getEntries()) {
                IQuest quest = (IQuest)((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getValue(entry.getID());
                if (quest.getProperty(NativeProps.LOGIC_QUEST) == EnumLogic.XOR) {
                    totalQuests -= Math.max(0, quest.getRequirements().length - 1);
                }
                if (quest.getProperty(NativeProps.VISIBILITY) == EnumQuestVisibility.HIDDEN) continue;
                ++totalQuests;
                if (!quest.isComplete(playerUUId)) continue;
                ++questsCompleted;
            }
            this.txCompletion.setText(questsCompleted + "/" + totalQuests);
        }
    }

    private void openQuestLine(DBEntry<IQuestLine> q) {
        this.selectedLine = (IQuestLine)q.getValue();
        selectedLineId = q.getID();
        for (int i = 0; i < this.btnListRef.size(); ++i) {
            this.btnListRef.get(i).setActive(((Integer)this.visChapters.get(i).func_76340_b() & 4) == 0 && q.getID() != selectedLineId);
        }
        this.cvQuest.setQuestLine((IQuestLine)q.getValue());
        this.icoChapter.setTexture((IGuiTexture)new OreDictTexture(1.0f, (BigItemStack)((IQuestLine)q.getValue()).getProperty(NativeProps.ICON), false, true), null);
        this.txTitle.setText(QuestTranslation.translate((String)((IQuestLine)q.getValue()).getUnlocalisedName(), (Object[])new Object[0]));
        this.refreshQuestCompletion();
        this.cvQuest.fitToWindow();
        this.refreshClaimAll();
        this.refreshDesigner();
    }

    private void refreshContent() {
        if (selectedLineId >= 0) {
            this.selectedLine = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(selectedLineId);
            if (this.selectedLine == null) {
                selectedLineId = -1;
            }
        } else {
            this.selectedLine = null;
        }
        float zoom = this.cvQuest.getZoom();
        int sx = this.cvQuest.getScrollX();
        int sy = this.cvQuest.getScrollY();
        this.cvQuest.setQuestLine(this.selectedLine);
        this.cvQuest.setZoom(zoom);
        this.cvQuest.setScrollX(sx);
        this.cvQuest.setScrollY(sy);
        this.cvQuest.refreshScrollBounds();
        this.cvQuest.updatePanelScroll();
        if (this.selectedLine != null) {
            this.refreshQuestCompletion();
            this.txTitle.setText(QuestTranslation.translate((String)this.selectedLine.getUnlocalisedName(), (Object[])new Object[0]));
            this.txDesc.setText(QuestTranslation.translate((String)this.selectedLine.getUnlocalisedDescription(), (Object[])new Object[0]));
            this.txDescScrolling.refreshScrollBounds();
            this.txDescScrolling.updatePanelScroll();
            this.txDescDriver.setEnabled(this.txDescScrolling.getScrollBounds().getHeight() > 0);
            this.icoChapter.setTexture((IGuiTexture)new OreDictTexture(1.0f, (BigItemStack)this.selectedLine.getProperty(NativeProps.ICON), false, true), null);
        } else {
            this.txTitle.setText("");
            this.txDesc.setText("");
            this.txDescScrolling.refreshScrollBounds();
            this.txDescScrolling.updatePanelScroll();
            this.txDescDriver.setEnabled(this.txDescScrolling.getScrollBounds().getHeight() > 0);
            this.icoChapter.setTexture(null, null);
        }
        this.refreshClaimAll();
        this.refreshDesigner();
    }

    private void refreshClaimAll() {
        if (this.cvQuest.getQuestLine() == null || this.cvQuest.getQuestButtons().size() <= 0) {
            this.claimAll.setActive(false);
            this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture(), (IGuiColor)new GuiColorStatic(-12303292), 0);
            return;
        }
        for (PanelButtonQuest btn : this.cvQuest.getQuestButtons()) {
            if (!((IQuest)((DBEntry)btn.getStoredValue()).getValue()).canClaim((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
            this.claimAll.setActive(true);
            this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture(), (IGuiColor)new GuiColorPulse(-1, -12303292, 2.0, 0.0f), 0);
            return;
        }
        this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture(), (IGuiColor)new GuiColorStatic(-12303292), 0);
        this.claimAll.setActive(false);
    }

    private void refreshDesigner() {
        if (this.btnDesign != null) {
            this.btnDesign.setActive(this.selectedLine != null);
        }
    }

    private void openSearch(PanelButton panelButton) {
        GuiQuestSearch guiQuestSearch = new GuiQuestSearch((GuiScreen)this);
        guiQuestSearch.setCallback(entry -> {
            this.openQuestLine((DBEntry<IQuestLine>)entry.getQuestLineEntry());
            int selectedQuestId = entry.getQuest().getID();
            Optional<PanelButtonQuest> targetQuestButton = this.cvQuest.getQuestButtons().stream().filter(panelButtonQuest -> ((DBEntry)panelButtonQuest.getStoredValue()).getID() == selectedQuestId).findFirst();
            targetQuestButton.ifPresent(panelButtonQuest -> {
                GuiTextureColored newTexture = new GuiTextureColored(panelButtonQuest.txFrame, (IGuiColor)new GuiColorPulse((IGuiColor)new GuiColorStatic(255, 220, 115, 255), (IGuiColor)new GuiColorStatic(255, 191, 0, 255), 1.0, 0.0f));
                panelButtonQuest.setTextures((IGuiTexture)newTexture, (IGuiTexture)newTexture, (IGuiTexture)newTexture);
            });
        });
        this.field_146297_k.func_147108_a((GuiScreen)guiQuestSearch);
    }
}

