/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.util.compat.jei;

import cassiokf.industrialrenewal.gui.GUILatheMachine;
import cassiokf.industrialrenewal.gui.container.ContainerLatheMachine;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.util.compat.jei.lathe.LatheRecipeCategory;
import cassiokf.industrialrenewal.util.compat.jei.lathe.LatheRecipeMaker;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JEICompat
implements IModPlugin {
    private static final List<ItemStack> blackListedItems = new CopyOnWriteArrayList<ItemStack>();

    public static String translateToLocal(String key) {
        return I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    public static String translateToLocalFormated(String key, Object ... format) {
        String s = JEICompat.translateToLocal(key);
        try {
            return String.format(s, format);
        }
        catch (IllegalFormatException e) {
            return "Format error: " + s;
        }
    }

    private void blackListItems(IJeiHelpers helpers) {
        blackListedItems.clear();
        blackListedItems.add(new ItemStack((Item)ModItems.pointer));
        blackListedItems.add(new ItemStack((Item)ModItems.limiter));
        blackListedItems.add(new ItemStack((Item)ModItems.pointerLong));
        blackListedItems.add(new ItemStack((Item)ModItems.fire));
        blackListedItems.add(new ItemStack((Item)ModItems.barLevel));
        blackListedItems.add(new ItemStack((Item)ModItems.fluidLoaderArm));
        blackListedItems.add(new ItemStack((Item)ModItems.tambor));
        blackListedItems.add(new ItemStack((Item)ModItems.cutter));
        blackListedItems.add(new ItemStack((Item)ModItems.indicator_on));
        blackListedItems.add(new ItemStack((Item)ModItems.indicator_off));
        blackListedItems.add(new ItemStack((Item)ModItems.switch_on));
        blackListedItems.add(new ItemStack((Item)ModItems.switch_off));
        blackListedItems.add(new ItemStack((Item)ModItems.push_button));
        blackListedItems.add(new ItemStack((Item)ModItems.label_5));
        blackListedItems.add(new ItemStack((Item)ModItems.discR));
        for (ItemStack item : blackListedItems) {
            helpers.getItemBlacklist().addItemToBlacklist(item);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers helpers = registry.getJeiHelpers();
        IGuiHelper gui = helpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new LatheRecipeCategory(gui)});
    }

    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IRecipeTransferRegistry transferRegistry = registry.getRecipeTransferRegistry();
        this.blackListItems(jeiHelpers);
        registry.addRecipes(LatheRecipeMaker.getRecipes(jeiHelpers), "industrialrenewal.lathe");
        registry.addRecipeClickArea(GUILatheMachine.class, 62, 35, 70, 26, new String[]{"industrialrenewal.lathe"});
        transferRegistry.addRecipeTransferHandler(ContainerLatheMachine.class, "industrialrenewal.lathe", 0, 1, 1, 36);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.latheMachine), new String[]{"industrialrenewal.lathe"});
    }
}

