/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.util;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

public class VoltsEnergyContainer
implements IEnergyStorage,
INBTSerializable<NBTTagCompound> {
    protected int stored;
    protected int capacity;
    protected int input;
    protected int output;

    public VoltsEnergyContainer() {
        this(1000, 1000, 1000);
    }

    public VoltsEnergyContainer(int capacity, int input, int output) {
        this(0, capacity, input, output);
    }

    public VoltsEnergyContainer(int power, int capacity, int input, int output) {
        this.stored = power;
        this.capacity = capacity;
        this.input = input;
        this.output = output;
    }

    public VoltsEnergyContainer(NBTTagCompound dataTag) {
        this.deserializeNBT(dataTag);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound dataTag = new NBTTagCompound();
        this.serializeNBT(dataTag);
        return dataTag;
    }

    public void serializeNBT(NBTTagCompound compound) {
        compound.func_74768_a("IRStored", this.stored);
        compound.func_74768_a("IRCapacity", this.capacity);
        compound.func_74768_a("IRInput", this.input);
        compound.func_74768_a("IROutput", this.output);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("IRStored")) {
            this.stored = nbt.func_74762_e("IRStored");
        }
        if (nbt.func_74764_b("IRCapacity")) {
            this.capacity = nbt.func_74762_e("IRCapacity");
        }
        if (nbt.func_74764_b("IRInput")) {
            this.input = nbt.func_74762_e("IRInput");
        }
        if (nbt.func_74764_b("IROutput")) {
            this.output = nbt.func_74762_e("IROutput");
        }
        if (this.stored > this.getMaxEnergyStored()) {
            this.stored = this.getMaxEnergyStored();
        }
    }

    public int receiveInternally(int maxReceive, boolean simulate) {
        int acceptedPower = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.getMaxInput(), maxReceive));
        if (!simulate) {
            this.stored += acceptedPower;
            this.onEnergyChange();
        }
        return acceptedPower;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int acceptedPower = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.getMaxInput(), maxReceive));
        if (!simulate) {
            this.stored += acceptedPower;
            this.onEnergyChange();
        }
        return this.canReceive() ? acceptedPower : 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int removedPower = Math.min(this.getEnergyStored(), Math.min(this.getMaxOutput(), maxExtract));
        if (!simulate) {
            this.stored -= removedPower;
            this.onEnergyChange();
        }
        return this.canExtract() ? removedPower : 0;
    }

    public int extractEnergyInternally(int maxExtract, boolean simulate) {
        int removedPower = Math.min(this.getEnergyStored(), Math.min(this.getMaxOutput(), maxExtract));
        if (!simulate) {
            this.stored -= removedPower;
            this.onEnergyChange();
        }
        return removedPower;
    }

    public int getEnergyStored() {
        return this.stored;
    }

    public void setEnergyStored(int stored) {
        this.stored = stored;
        this.onEnergyChange();
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public void setMaxEnergyStored(int capacity) {
        this.capacity = capacity;
        if (this.stored > capacity) {
            this.stored = capacity;
        }
    }

    public void onEnergyChange() {
    }

    public int getMaxInput() {
        return this.input;
    }

    public void setMaxInput(int input) {
        this.input = input;
    }

    public int getMaxOutput() {
        return this.output;
    }

    public void setMaxOutput(int output) {
        this.output = output;
    }

    public boolean canExtract() {
        return this.getMaxOutput() > 0 && this.stored > 0;
    }

    public boolean canReceive() {
        return this.getMaxInput() > 0;
    }
}

