/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.tileentity.abstracts.TEBase;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntitySolarPanelBase
extends TEBase
implements ITickable {
    public final VoltsEnergyContainer energyContainer = new VoltsEnergyContainer(600, 120, 120){

        @Override
        public boolean canReceive() {
            return false;
        }

        @Override
        public boolean canExtract() {
            return false;
        }

        @Override
        public int receiveInternally(int maxReceive, boolean simulate) {
            return TileEntitySolarPanelBase.this.moveEnergyOut(maxReceive, simulate);
        }
    };
    private int tick;
    private final int random = ThreadLocalRandom.current().nextInt(10);
    private int energyCanGenerate;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tick >= 20 + this.random) {
                this.tick = 0;
                this.getEnergyFromSun();
            }
            ++this.tick;
            if (this.energyCanGenerate > 0) {
                this.energyContainer.receiveInternally(this.energyCanGenerate, false);
            }
        }
    }

    public int moveEnergyOut(int energy, boolean simulate) {
        IEnergyStorage consumer;
        EnumFacing facing = EnumFacing.DOWN;
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        int out = 0;
        if (tileEntity != null && (consumer = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) != null && consumer.canReceive()) {
            out = consumer.receiveEnergy(energy, simulate);
        }
        return out;
    }

    public static int getGeneration(World world, BlockPos pos) {
        int i = world.func_175642_b(EnumSkyBlock.SKY, pos) - world.func_175657_ab();
        float f = world.func_72929_e(1.0f);
        if (i > 0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            i = Math.round((float)i * MathHelper.func_76134_b((float)f));
        }
        i = MathHelper.func_76125_a((int)i, (int)0, (int)15);
        float normalize = (float)i / 15.0f;
        if (world.func_72896_J()) {
            normalize /= 2.0f;
        }
        return Math.round(normalize * (float)IRConfig.MainConfig.Main.baseSolarPanelMaxGeneration);
    }

    public void getEnergyFromSun() {
        if (this.field_145850_b.field_73011_w.func_191066_m() && this.field_145850_b.func_175710_j(this.field_174879_c.func_177972_a(EnumFacing.UP)) && this.field_145850_b.func_175657_ab() == 0 && this.energyContainer.getEnergyStored() != this.energyContainer.getMaxEnergyStored()) {
            this.energyCanGenerate = TileEntitySolarPanelBase.getGeneration(this.field_145850_b, this.field_174879_c);
        }
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing == EnumFacing.DOWN) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyContainer);
        }
        return (T)super.getCapability(capability, facing);
    }
}

