/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.BlockGutter;
import cassiokf.industrialrenewal.blocks.BlockRoof;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityMultiBlocksTube;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityGutter
extends TileEntityMultiBlocksTube<TileEntityGutter> {
    EnumFacing blockFacing = null;
    public final FluidTank tank = new FluidTank(1000){

        public boolean canFill() {
            return false;
        }

        protected void onContentsChanged() {
            TileEntityGutter.this.func_70296_d();
        }
    };
    private int tick;
    private int fillAmount;

    @Override
    public void tick() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            if (this.isMaster()) {
                if (this.field_145850_b.func_72896_J()) {
                    this.tank.fillInternal(new FluidStack(FluidRegistry.WATER, this.fillAmount), true);
                }
                if (this.tank.getFluidAmount() > 0) {
                    int quantity = this.getMachineContainers().size() > 0 ? this.tank.getFluidAmount() / this.getMachineContainers().size() : 0;
                    for (TileEntity tileEntity : this.getMachineContainers().keySet()) {
                        EnumFacing facing;
                        IFluidHandler consumer;
                        if (tileEntity == null || tileEntity.func_145837_r() || (consumer = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing = this.getMachineContainers().get(tileEntity).func_176734_d())) == null) continue;
                        this.tank.drain(consumer.fill(this.tank.drain(quantity, false), true), true);
                    }
                }
            }
            if (this.tick >= 100) {
                this.tick = 0;
                if (this.field_145850_b.func_72896_J()) {
                    this.checkIfIsReady();
                }
            }
            ++this.tick;
        }
    }

    @Override
    public boolean instanceOf(TileEntity te) {
        return te instanceof TileEntityGutter;
    }

    @Override
    public void checkForOutPuts() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        EnumFacing face = EnumFacing.DOWN;
        BlockPos currentPos = this.field_174879_c.func_177972_a(face);
        IBlockState state = this.field_145850_b.func_180495_p(currentPos);
        TileEntity te = this.field_145850_b.func_175625_s(currentPos);
        if (te == null) {
            return;
        }
        boolean hasMachine = !(state.func_177230_c() instanceof BlockGutter);
        IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d());
        if (hasMachine && handler != null && handler.getTankProperties().length > 0 && handler.getTankProperties()[0].canFill()) {
            this.addMachine(te, face);
        } else {
            this.removeMachine(te);
        }
    }

    public void checkIfIsReady() {
        int f = 1;
        this.fillAmount = 0;
        EnumFacing face = this.getBlockFacing();
        while (this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(face, f)).func_177230_c() instanceof BlockRoof) {
            ++((TileEntityGutter)this.getMaster()).fillAmount;
            ++f;
        }
    }

    @Override
    public EnumFacing[] getFacesToCheck() {
        EnumFacing facing = this.getBlockFacing();
        return new EnumFacing[]{facing.func_176746_e(), facing.func_176735_f()};
    }

    public EnumFacing getBlockFacing() {
        if (this.blockFacing != null) {
            return this.blockFacing;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.blockFacing = state.func_177230_c() instanceof BlockGutter ? (EnumFacing)state.func_177229_b((IProperty)BlockGutter.FACING) : EnumFacing.NORTH;
        return this.blockFacing;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == EnumFacing.DOWN) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)((TileEntityGutter)this.getMaster()).tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        super.func_145839_a(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return super.func_189515_b(tag);
    }
}

