/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.BlockGauge;
import cassiokf.industrialrenewal.tileentity.abstracts.TEBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityGauge
extends TEBase {
    private EnumFacing baseFacing = EnumFacing.DOWN;
    private EnumFacing indicatorHorizontalFacing;
    private IFluidHandler tankStorage;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public EnumFacing getBaseFacing() {
        return this.baseFacing;
    }

    public void setBaseFacing(EnumFacing facing) {
        this.baseFacing = facing;
        this.func_70296_d();
    }

    public EnumFacing getGaugeFacing() {
        if (this.indicatorHorizontalFacing != null) {
            return this.indicatorHorizontalFacing;
        }
        return this.forceIndicatorCheck();
    }

    public EnumFacing forceIndicatorCheck() {
        this.indicatorHorizontalFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockGauge.FACING);
        return this.indicatorHorizontalFacing;
    }

    public String GetText() {
        IFluidTankProperties properties;
        if (this.getTankStorage() != null && this.getTankStorage().getTankProperties().length > 0 && (properties = this.getTankStorage().getTankProperties()[0]) != null) {
            FluidStack stack = properties.getContents();
            return stack != null ? stack.getLocalizedName() : "Empty";
        }
        return "No Tank";
    }

    public float GetTankFill() {
        IFluidTankProperties properties;
        if (this.getTankStorage() != null && this.getTankStorage().getTankProperties().length > 0 && (properties = this.getTankStorage().getTankProperties()[0]) != null && properties.getContents() != null) {
            float currentAmount = (float)properties.getContents().amount / 1000.0f;
            float totalCapacity = (float)properties.getCapacity() / 1000.0f;
            return (currentAmount /= totalCapacity) * 180.0f;
        }
        return 0.0f;
    }

    private IFluidHandler getTankStorage() {
        if (this.tankStorage != null) {
            return this.tankStorage;
        }
        return this.forceCheck();
    }

    public IFluidHandler forceCheck() {
        IFluidHandler handler;
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.baseFacing));
        if (te != null && (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.baseFacing.func_176734_d())) != null) {
            this.tankStorage = handler;
            return this.tankStorage;
        }
        this.tankStorage = null;
        return null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74768_a("baseFacing", this.baseFacing.func_176745_a());
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.baseFacing = EnumFacing.func_82600_a((int)tag.func_74762_e("baseFacing"));
        super.func_145839_a(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }
}

