/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.handlers.IRSoundHandler;
import cassiokf.industrialrenewal.init.IRSoundRegister;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntityMultiBlockBase;
import cassiokf.industrialrenewal.util.MachinesUtils;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.interfaces.ICompressedFluidCapability;
import cassiokf.industrialrenewal.util.interfaces.IDynamicSound;
import cassiokf.industrialrenewal.util.interfaces.IMecanicalEnergy;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class TileEntityDamTurbine
extends TileEntityMultiBlockBase<TileEntityDamTurbine>
implements ICompressedFluidCapability,
IDynamicSound {
    private final float volume;
    private BlockPos outPos;
    private int passedFluid;
    private boolean hasFlow;
    private float oldRotation;
    private float rotation;

    public TileEntityDamTurbine() {
        this.volume = IRConfig.MainConfig.Sounds.turbineVolume * IRConfig.MainConfig.Sounds.masterVolumeMult;
        this.outPos = null;
        this.passedFluid = 0;
        this.hasFlow = false;
    }

    @Override
    public void onTick() {
        if (this.isMaster()) {
            if (!this.field_145850_b.field_72995_K) {
                this.doRotation();
                this.passRotationUp();
            } else {
                this.updateSound(this.getPitch());
            }
        }
    }

    private void updateSound(float pitch) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.rotation > 0.0f) {
            IRSoundHandler.playRepeatableSound(IRSoundRegister.MOTOR_ROTATION_RESOURCEL, this.volume, pitch, this.field_174879_c);
        } else {
            IRSoundHandler.stopTileSound(this.field_174879_c);
        }
    }

    @Override
    public void onMasterBreak() {
        if (this.field_145850_b.field_72995_K) {
            IRSoundHandler.stopTileSound(this.field_174879_c);
        }
    }

    private void passRotationUp() {
        if (this.rotation <= 0.0f) {
            return;
        }
        BlockPos outPos = this.field_174879_c.func_177981_b(2);
        TileEntity te = this.field_145850_b.func_175625_s(outPos);
        if (te instanceof IMecanicalEnergy && ((IMecanicalEnergy)te).canAcceptRotation(outPos, EnumFacing.DOWN)) {
            ((IMecanicalEnergy)te).passRotation((int)this.rotation);
        }
    }

    private void doRotation() {
        float norm = Utils.normalizeClamped(this.passedFluid, 0.0f, 1000.0f);
        if (this.hasFlow) {
            float max = 6000.0f * norm;
            if (this.rotation < max) {
                this.rotation += Math.min(norm * 10.0f, max - this.rotation);
            } else if (this.rotation > max) {
                this.rotation -= 1.0f;
            }
        } else if (this.rotation > 0.0f) {
            this.rotation -= 10.0f;
        }
        this.rotation = MathHelper.func_76131_a((float)this.rotation, (float)0.0f, (float)6000.0f);
        if (this.rotation != this.oldRotation) {
            this.oldRotation = this.rotation;
            this.sync();
        }
        this.hasFlow = false;
    }

    @Override
    public List<BlockPos> getListOfBlockPositions(BlockPos centerPosition) {
        return MachinesUtils.getBlocksIn3x2x3CenteredPlus1OnTop(centerPosition);
    }

    @Override
    public boolean instanceOf(TileEntity tileEntity) {
        return tileEntity instanceof TileEntityDamTurbine;
    }

    private BlockPos getOutPutPosition() {
        if (this.outPos != null) {
            return this.outPos;
        }
        EnumFacing facing = this.getMasterFacing();
        this.outPos = ((TileEntityDamTurbine)this.getMaster()).func_174877_v().func_177977_b().func_177972_a(facing.func_176734_d()).func_177972_a(facing.func_176735_f());
        return this.outPos;
    }

    @Override
    public boolean canAccept(EnumFacing face, BlockPos pos) {
        if (this.getMaster() == null) {
            return false;
        }
        EnumFacing facing = this.getMasterFacing();
        return face.equals((Object)facing) && pos.equals((Object)((TileEntityDamTurbine)this.getMaster()).func_174877_v().func_177972_a(facing).func_177972_a(facing.func_176746_e()));
    }

    @Override
    public boolean canPipeConnect(EnumFacing face, BlockPos pos) {
        EnumFacing facing = this.getMasterFacing();
        if (face.equals((Object)facing)) {
            return this.canAccept(face, pos);
        }
        return face.equals((Object)facing.func_176735_f()) && pos.equals((Object)this.getOutPutPosition());
    }

    @Override
    public int passCompressedFluid(int amount, int y, boolean simulate) {
        if (!this.isMaster()) {
            return ((TileEntityDamTurbine)this.getMaster()).passCompressedFluid(amount, y, simulate);
        }
        int height = y - this.field_174879_c.func_177956_o();
        if (height < 0) {
            return 0;
        }
        int realAmount = 0;
        EnumFacing outPutFace = this.getMasterFacing().func_176735_f();
        BlockPos outPutPos = this.getOutPutPosition().func_177972_a(outPutFace);
        TileEntity te = this.field_145850_b.func_175625_s(outPutPos);
        if (te instanceof ICompressedFluidCapability && ((ICompressedFluidCapability)te).canAccept(outPutFace.func_176734_d(), outPutPos)) {
            realAmount = ((ICompressedFluidCapability)te).passCompressedFluid(amount, this.field_174879_c.func_177956_o() - 1, simulate);
        }
        this.passedFluid = realAmount;
        if (!simulate && realAmount > 0) {
            this.hasFlow = true;
        }
        return realAmount;
    }

    public String getRotationText() {
        return "Rot: " + (int)this.rotation + " rpm";
    }

    public float getRotationFill() {
        return this.getNormalizedRotation() * 180.0f;
    }

    private float getNormalizedRotation() {
        return Utils.normalizeClamped(this.rotation, 0.0f, 6000.0f);
    }

    @Override
    public float getPitch() {
        return this.getNormalizedRotation() * 0.7f;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74776_a("rotation", this.rotation);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.rotation = compound.func_74760_g("rotation");
        super.func_145839_a(compound);
    }
}

