/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.redstone.BlockFuseBox;
import cassiokf.industrialrenewal.blocks.redstone.BlockFuseBoxConnector;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.tileentity.abstracts.TEBase;
import cassiokf.industrialrenewal.tileentity.redstone.TileEntityFuseBox;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityBoxConnector
extends TEBase {
    private boolean active;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public int passRedstone() {
        int value = this.getActive() ? this.getSignalWithAllTheMath(this.getPowerIn()) : 0;
        return value;
    }

    public int getSignalWithAllTheMath(int input) {
        ItemStackHandler inv = this.getInventory();
        if (inv != null) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                Item item = inv.getStackInSlot(i).func_77973_b();
                if (item == ModItems.cartridge_minus) {
                    --input;
                }
                if (item == ModItems.cartridge_plus) {
                    ++input;
                }
                if (item == ModItems.cartridge_half) {
                    input /= 2;
                }
                if (item == ModItems.cartridge_double) {
                    input *= 2;
                }
                if (item != ModItems.cartridge_inverter) continue;
                input = input > 0 ? 0 : 15;
            }
        }
        if (input > 15) {
            input = 15;
        }
        if (input < 0) {
            input = 0;
        }
        return input;
    }

    private ItemStackHandler getInventory() {
        TileEntityFuseBox te = this.getTE();
        if (te != null) {
            return te.getInv();
        }
        return null;
    }

    public int getPowerIn() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing inFace = ((EnumFacing)state.func_177229_b((IProperty)BlockFuseBoxConnector.FACING)).func_176735_f();
        IBlockState neighbor = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(inFace));
        Block block = neighbor.func_177230_c();
        if (block == Blocks.field_150451_bX || block == Blocks.field_150429_aA) {
            return 15;
        }
        return block == Blocks.field_150488_af ? ((Integer)neighbor.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)).intValue() : this.field_145850_b.func_175627_a(this.field_174879_c.func_177972_a(inFace), inFace);
    }

    private void notifyChange() {
        this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, true);
        this.func_70296_d();
    }

    public boolean getActive() {
        boolean nActive;
        TileEntityFuseBox te = this.getTE();
        if (te != null && (nActive = te.getActive()) != this.active) {
            this.setActive(nActive);
        }
        return this.active;
    }

    public void setActive(boolean value) {
        this.active = value;
        this.notifyChange();
    }

    private TileEntityFuseBox getTE() {
        for (int i = 1; i < 64; ++i) {
            Block block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177981_b(i)).func_177230_c();
            if (!(block instanceof BlockFuseBox)) continue;
            return (TileEntityFuseBox)this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(i));
        }
        return null;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("active", this.active);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.active = compound.func_74767_n("active");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

