/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.network;

import cassiokf.industrialrenewal.tileentity.TEStorageChest;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketStorageChest
implements IMessage {
    private boolean messageValid;
    private BlockPos pos;
    private int currentLine;
    private int additionalLine;

    public PacketStorageChest() {
        this.messageValid = false;
    }

    public PacketStorageChest(BlockPos pos, int currentLine, int additionalLine) {
        this.currentLine = currentLine;
        this.additionalLine = additionalLine;
        this.pos = pos;
        this.messageValid = true;
    }

    public PacketStorageChest(TEStorageChest te) {
        this(te.func_174877_v(), te.currentLine, te.additionalLines);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.currentLine = buf.readInt();
            this.additionalLine = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            System.out.println(ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.currentLine);
        buf.writeInt(this.additionalLine);
    }

    public static class Handler
    implements IMessageHandler<PacketStorageChest, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketStorageChest message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(PacketStorageChest message, MessageContext ctx) {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
            if (te instanceof TEStorageChest) {
                ((TEStorageChest)te).setLineValues(message.currentLine, message.additionalLine);
            }
        }
    }
}

