/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.item;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.item.ItemBase;
import cassiokf.industrialrenewal.tileentity.TileEntityHVConnectorBase;
import cassiokf.industrialrenewal.tileentity.TileEntityTransformerHV;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.interfaces.IConnectorHV;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCoilHV
extends ItemBase {
    private BlockPos firstConnectionPos;
    private boolean isSecond = false;

    public ItemCoilHV(String name, CreativeTabs tab) {
        super(name, tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        list.add("Long distance energy transport");
    }

    /*
     * Enabled aggressive block sorting
     */
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            player.func_184609_a(hand);
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        if (!hand.equals((Object)EnumHand.MAIN_HAND)) return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null) {
            this.cleanConnection(player);
            return EnumActionResult.PASS;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        if (te instanceof IConnectorHV) {
            IConnectorHV teT = (IConnectorHV)te;
            if (teT instanceof TileEntityTransformerHV) {
                teT = (IConnectorHV)((TileEntityTransformerHV)teT).getMaster();
            }
            if (!this.isSecond) {
                if (teT.canConnect(pos)) {
                    this.firstConnectionPos = teT.getConnectorPos();
                    this.isSecond = true;
                    Utils.sendChatMessage(player, "Connection Start");
                    return EnumActionResult.SUCCESS;
                }
                Utils.sendChatMessage(player, "Connection already in use");
                return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
            }
            int distance = Utils.getDistancePointToPoint(this.firstConnectionPos, pos);
            if (teT.getConnectorPos() != this.firstConnectionPos && teT.canConnect(pos) && distance > 0 && distance <= IRConfig.MainConfig.Main.maxHVWireLength) {
                this.isSecond = false;
                this.connectFirst(worldIn, teT.getConnectorPos());
                teT.connect(this.firstConnectionPos);
                Utils.sendChatMessage(player, "Connected Distance: " + distance);
                itemstack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
            if (distance > IRConfig.MainConfig.Main.maxHVWireLength) {
                Utils.sendChatMessage(player, "Far away from each other, Distence: " + distance);
            }
            this.cleanConnection(player);
            return EnumActionResult.FAIL;
        }
        if (!(te instanceof TileEntityHVConnectorBase)) {
            if (!this.isSecond) return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
            this.cleanConnection(player);
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        TileEntityHVConnectorBase teT = (TileEntityHVConnectorBase)te;
        if (!this.isSecond) {
            if (teT.canConnect()) {
                this.firstConnectionPos = teT.func_174877_v();
                this.isSecond = true;
                Utils.sendChatMessage(player, "Connection Start");
                return EnumActionResult.SUCCESS;
            }
            Utils.sendChatMessage(player, "Connection already in use");
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        int distance = Utils.getDistancePointToPoint(this.firstConnectionPos, pos);
        if (teT.func_174877_v() != this.firstConnectionPos && teT.canConnect() && distance > 0 && distance <= IRConfig.MainConfig.Main.maxHVWireLength) {
            this.isSecond = false;
            this.connectFirst(worldIn, teT.func_174877_v());
            teT.setConnection(this.firstConnectionPos);
            Utils.sendChatMessage(player, "Connected Distance: " + distance);
            itemstack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        if (distance > IRConfig.MainConfig.Main.maxHVWireLength) {
            Utils.sendChatMessage(player, "Far away from each other, Distence: " + distance);
        }
        this.cleanConnection(player);
        return EnumActionResult.FAIL;
    }

    public String getDistanceText(EntityPlayer player) {
        if (!this.isSecond) {
            return "";
        }
        int distance = Utils.getDistancePointToPoint(this.firstConnectionPos, player.func_180425_c());
        String text = "Current Wire Distance: " + distance;
        return (distance > IRConfig.MainConfig.Main.maxHVWireLength ? TextFormatting.RED : TextFormatting.GREEN) + text;
    }

    private void cleanConnection(EntityPlayer player) {
        this.isSecond = false;
        Utils.sendChatMessage(player, "Can not connect");
    }

    private void connectFirst(World world, BlockPos endPos) {
        TileEntity te = world.func_175625_s(this.firstConnectionPos);
        if (te instanceof IConnectorHV) {
            ((IConnectorHV)te).connect(endPos);
        } else if (te instanceof TileEntityHVConnectorBase) {
            ((TileEntityHVConnectorBase)te).setConnection(endPos);
        }
    }
}

