/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.entity;

import cassiokf.industrialrenewal.IndustrialRenewal;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.entity.EntityFluidBase;
import cassiokf.industrialrenewal.entity.RotatableBase;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.interfaces.ICoupleCart;
import javax.annotation.Nonnull;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class EntityTenderBase
extends RotatableBase
implements ICoupleCart,
IInventory {
    private static final DataParameter<NBTTagCompound> TANK = EntityDataManager.func_187226_a(EntityFluidBase.class, (DataSerializer)DataSerializers.field_192734_n);
    public final ItemStackHandler inventory = new ItemStackHandler(6){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            return TileEntityFurnace.func_145954_b((ItemStack)stack);
        }
    };
    public final FluidTank tank = new FluidTank(64000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && IRConfig.waterTypesContains(fluid.getFluid().getName());
        }

        protected void onContentsChanged() {
            EntityTenderBase.this.Sync();
        }
    };

    public EntityTenderBase(World worldIn) {
        super(worldIn);
    }

    public EntityTenderBase(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank)) {
            if (this.field_70170_p.field_72995_K) {
                player.func_184609_a(hand);
            }
            return true;
        }
        if (!player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                player.openGui((Object)IndustrialRenewal.instance, 11, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (!source.func_94541_c() && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_70099_a(new ItemStack((Item)ModItems.tender, 1), 0.0f);
        }
    }

    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.CHEST;
    }

    public ItemStack getCartItem() {
        return new ItemStack((Item)ModItems.tender);
    }

    @Override
    public float getFixedDistance(EntityMinecart cart) {
        return 0.6f;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("tankD", (NBTBase)this.field_70180_af.func_187225_a(TANK));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        this.field_70180_af.func_187227_b(TANK, (Object)compound.func_74775_l("tankD"));
    }

    public void Sync() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(TANK, (Object)this.GetTag());
        }
    }

    public NBTTagCompound GetTag() {
        NBTTagCompound tankCompound = new NBTTagCompound();
        this.tank.writeToNBT(tankCompound);
        return tankCompound;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TANK, (Object)new NBTTagCompound());
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.field_70170_p.field_72995_K && key.equals(TANK)) {
            this.tank.readFromNBT((NBTTagCompound)this.field_70180_af.func_187225_a(TANK));
        }
    }

    public int func_70302_i_() {
        return 6;
    }

    public boolean func_191420_l() {
        return Utils.IsInventoryEmpty((IItemHandler)this.inventory);
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.extractItem(index, count, false);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.extractItem(index, 64, false);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.setStackInSlot(index, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !player.func_175149_v();
    }

    public void func_174889_b(EntityPlayer player) {
        player.openGui((Object)IndustrialRenewal.instance, 11, this.field_70170_p, this.func_145782_y(), 0, 0);
    }

    public void func_174886_c(EntityPlayer player) {
        player.func_71053_j();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inventory.isItemValid(index, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

