/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.railroad;

import cassiokf.industrialrenewal.IndustrialRenewal;
import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.tileentity.railroad.TileEntityCargoLoader;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCargoLoader
extends BlockHorizontalFacing {
    public static final PropertyBool MASTER = PropertyBool.func_177716_a((String)"master");

    public BlockCargoLoader(String name, CreativeTabs tab) {
        super(name, tab, Material.field_151573_f);
    }

    public static BlockPos getMasterPos(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        for (int y = -2; y < 3; ++y) {
            BlockPos newPos = pos.func_177981_b(y);
            BlockPos newPosFront = pos.func_177972_a(facing).func_177981_b(y);
            BlockPos newPosBack = pos.func_177972_a(facing.func_176734_d()).func_177981_b(y);
            if (world.func_180495_p(newPos).func_177230_c() instanceof BlockCargoLoader && ((Boolean)world.func_180495_p(newPos).func_177229_b((IProperty)MASTER)).booleanValue()) {
                return newPos;
            }
            if (world.func_180495_p(newPosFront).func_177230_c() instanceof BlockCargoLoader && ((Boolean)world.func_180495_p(newPosFront).func_177229_b((IProperty)MASTER)).booleanValue()) {
                return newPosFront;
            }
            if (!(world.func_180495_p(newPosBack).func_177230_c() instanceof BlockCargoLoader) || !((Boolean)world.func_180495_p(newPosBack).func_177229_b((IProperty)MASTER)).booleanValue()) continue;
            return newPosBack;
        }
        return null;
    }

    private void OpenGUI(World world, BlockPos pos, EntityPlayer player) {
        player.openGui((Object)IndustrialRenewal.instance, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && hand.equals((Object)EnumHand.MAIN_HAND)) {
            if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
                TileEntity tileentity = worldIn.func_175625_s(pos);
                if (tileentity instanceof TileEntityCargoLoader) {
                    this.OpenGUI(worldIn, pos, playerIn);
                }
            } else {
                TileEntity tileentity;
                BlockPos masterPos = BlockCargoLoader.getMasterPos((IBlockAccess)worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
                if (masterPos != null && (tileentity = worldIn.func_175625_s(masterPos)) instanceof TileEntityCargoLoader) {
                    this.OpenGUI(worldIn, masterPos, playerIn);
                }
            }
        }
        return true;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            for (BlockPos pos1 : this.getBlocks(pos, facing)) {
                worldIn.func_175698_g(pos1);
            }
        } else {
            BlockPos masterPos = BlockCargoLoader.getMasterPos((IBlockAccess)worldIn, pos, facing);
            if (masterPos != null) {
                worldIn.func_175698_g(masterPos);
                for (BlockPos pos1 : this.getBlocks(masterPos, facing)) {
                    if (pos1 == pos) continue;
                    worldIn.func_175698_g(pos1);
                }
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    private Set<BlockPos> getBlocks(BlockPos posMaster, EnumFacing facing) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        positions.add(posMaster.func_177977_b());
        positions.add(posMaster.func_177977_b().func_177972_a(facing));
        positions.add(posMaster.func_177984_a());
        positions.add(posMaster.func_177984_a().func_177972_a(facing));
        return positions;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MASTER});
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(false));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(true)));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(false)));
            worldIn.func_175656_a(pos.func_177984_a().func_177972_a(facing), state.func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(false)));
            worldIn.func_175656_a(pos.func_177977_b(), state.func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(false)));
            worldIn.func_175656_a(pos.func_177977_b().func_177972_a(facing), state.func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        EntityPlayer player = worldIn.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0, false);
        if (player == null) {
            return false;
        }
        if (!this.func_176200_f((IBlockAccess)worldIn, pos)) {
            return false;
        }
        if (!this.func_176200_f((IBlockAccess)worldIn, pos.func_177984_a())) {
            return false;
        }
        if (!this.func_176200_f((IBlockAccess)worldIn, pos.func_177981_b(2))) {
            return false;
        }
        if (!this.func_176200_f((IBlockAccess)worldIn, pos.func_177981_b(2).func_177972_a(player.func_174811_aO()))) {
            return false;
        }
        return this.func_176200_f((IBlockAccess)worldIn, pos.func_177972_a(player.func_174811_aO()));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        int directionIndex = meta;
        if (meta > 3) {
            directionIndex -= 4;
        }
        boolean index = true;
        if (meta > 3) {
            index = false;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)directionIndex)).func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(index));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (!((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            i += 4;
        }
        return i;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntityCargoLoader createTileEntity(World world, IBlockState state) {
        return new TileEntityCargoLoader();
    }
}

