/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.abstracts;

import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.tileentity.TileEntityBarrel;
import cassiokf.industrialrenewal.tileentity.TileEntityPortableGenerator;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntitySaveContent;
import cassiokf.industrialrenewal.util.Utils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;

public abstract class BlockSaveContent
extends BlockHorizontalFacing {
    public BlockSaveContent(String name, CreativeTabs tab, Material material) {
        super(name, tab, material);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TileEntity te = worldIn.func_175625_s(pos);
            boolean acceptFluid = FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (World)worldIn, (BlockPos)pos, (EnumFacing)facing);
            if (!acceptFluid && te instanceof TileEntityBarrel) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(((TileEntityBarrel)te).GetChatQuantity()));
            } else if (!acceptFluid) {
                this.doAdditionalFunction(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
            }
        }
        return true;
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("FluidName") && nbt.func_74764_b("Amount")) {
            tooltip.add(nbt.func_74779_i("FluidName") + ": " + nbt.func_74762_e("Amount"));
        }
    }

    public void doAdditionalFunction(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityPortableGenerator && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("FluidName")) {
            ((TileEntityPortableGenerator)te).getTank().readFromNBT(stack.func_77978_p());
        }
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntitySaveContent) {
            ItemStack itemst = this.SaveStackContainer((TileEntitySaveContent)te);
            BlockSaveContent.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemst);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        return te instanceof TileEntitySaveContent ? (int)(Utils.normalizeClamped(((TileEntitySaveContent)te).getTank().getFluidAmount(), 0.0f, ((TileEntitySaveContent)te).getTank().getCapacity()) * 15.0f) : 0;
    }

    private ItemStack SaveStackContainer(TileEntitySaveContent te) {
        ItemStack stack = new ItemStack(this.getItemToDrop());
        if (te != null) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            if (te.getTank().getFluid() != null) {
                te.getTank().writeToNBT(nbt);
                stack.func_77982_d(nbt);
            }
        }
        return stack;
    }

    public abstract Item getItemToDrop();

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntitySaveContent te = (TileEntitySaveContent)world.func_175625_s(pos);
        return this.SaveStackContainer(te);
    }
}

