/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.abstracts.BlockMultiBlockBase;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.FluidInit;
import cassiokf.industrialrenewal.item.ItemFireBox;
import cassiokf.industrialrenewal.item.ItemPowerScrewDrive;
import cassiokf.industrialrenewal.tileentity.TileEntitySteamBoiler;
import cassiokf.industrialrenewal.util.MachinesUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSteamBoiler
extends BlockMultiBlockBase<TileEntitySteamBoiler> {
    public static final PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)2);

    public BlockSteamBoiler(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"info.industrialrenewal.requires", (Object[])new Object[0]) + ":");
        tooltip.add(" -" + I18n.func_135052_a((String)"info.industrialrenewal.firebox", (Object[])new Object[0]));
        tooltip.add(" -" + Blocks.field_150355_j.func_149732_F() + ": " + IRConfig.MainConfig.Main.steamBoilerWaterPerTick + " mB/t");
        tooltip.add(I18n.func_135052_a((String)"info.industrialrenewal.produces", (Object[])new Object[0]) + " " + FluidInit.STEAM.getName() + ": " + IRConfig.MainConfig.Main.steamBoilerWaterPerTick * IRConfig.MainConfig.Main.steamBoilerConversionFactor + " mB/t");
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        TileEntitySteamBoiler te = (TileEntitySteamBoiler)world.func_175625_s(pos);
        if (te != null && te.isMaster() && te.getType() != 0 && te.boiler.isBurning() && rand.nextInt(12) == 0) {
            world.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, (2.0f + rand.nextFloat()) * IRConfig.MainConfig.Sounds.masterVolumeMult, rand.nextFloat() * 0.7f + 0.3f);
        }
    }

    @Override
    public List<BlockPos> getMachineBlockPosList(BlockPos masterPos, EnumFacing facing) {
        return MachinesUtils.getBlocksIn3x3x3Centered(masterPos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntitySteamBoiler tile = (TileEntitySteamBoiler)this.getTileEntity((IBlockAccess)world, pos);
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && (heldItem.func_77973_b() instanceof ItemFireBox || heldItem.func_77973_b() instanceof ItemPowerScrewDrive)) {
            if (heldItem.func_77973_b() instanceof ItemFireBox && tile.getType() == 0) {
                int type = ((ItemFireBox)heldItem.func_77973_b()).type;
                tile.setType(type);
                if (!world.field_72995_K && !player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
                return true;
            }
            if (heldItem.func_77973_b() instanceof ItemPowerScrewDrive && tile.getType() != 0) {
                if (!world.field_72995_K && !player.func_184812_l_()) {
                    player.func_191521_c(tile.getFireBoxStack());
                }
                tile.setType(0);
                return true;
            }
        }
        return false;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MASTER, TYPE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntitySteamBoiler && ((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            return state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(((TileEntitySteamBoiler)te).getType()));
        }
        return state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(0));
    }

    @Override
    @Nullable
    public TileEntitySteamBoiler createTileEntity(World world, IBlockState state) {
        return new TileEntitySteamBoiler();
    }
}

